/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.client.spring.actuate;

import java.util.ArrayList;
import java.util.List;
import org.entur.jwt.client.AccessTokenHealth;
import org.entur.jwt.client.AccessTokenHealthNotSupportedException;
import org.entur.jwt.client.AccessTokenHealthProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class AccessTokenProviderHealthIndicator
extends AbstractHealthIndicator {
    protected static final Logger logger = LoggerFactory.getLogger(AccessTokenProviderHealthIndicator.class);
    private final AccessTokenHealthProvider[] providers;
    private Boolean previousHealthSuccess;

    public AccessTokenProviderHealthIndicator(AccessTokenHealthProvider[] statusProviders) {
        this.providers = statusProviders;
    }

    public AccessTokenProviderHealthIndicator(List<AccessTokenHealthProvider> statusProviders) {
        this(statusProviders.toArray(new AccessTokenHealthProvider[statusProviders.size()]));
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        if (this.providers.length > 0) {
            try {
                boolean success = true;
                long mostRecentTimestamp = Long.MIN_VALUE;
                long leastRecentTimestamp = Long.MAX_VALUE;
                ArrayList<AccessTokenHealth> accessTokenHealths = new ArrayList<AccessTokenHealth>(this.providers.length);
                for (AccessTokenHealthProvider provider : this.providers) {
                    AccessTokenHealth status = provider.getHealth(true);
                    if (status == null) continue;
                    accessTokenHealths.add(status);
                }
                if (!accessTokenHealths.isEmpty()) {
                    for (AccessTokenHealth status : accessTokenHealths) {
                        if (!status.isSuccess()) {
                            success = false;
                        }
                        if (mostRecentTimestamp < status.getTimestamp()) {
                            mostRecentTimestamp = status.getTimestamp();
                        }
                        if (leastRecentTimestamp <= status.getTimestamp()) continue;
                        leastRecentTimestamp = status.getTimestamp();
                    }
                    long time = System.currentTimeMillis();
                    if (mostRecentTimestamp != Long.MIN_VALUE) {
                        builder.withDetail("youngestTimestamp", (Object)((time - mostRecentTimestamp) / 1000L));
                    }
                    if (leastRecentTimestamp != Long.MAX_VALUE) {
                        builder.withDetail("oldestTimestamp", (Object)((time - leastRecentTimestamp) / 1000L));
                    }
                    this.logInitialOrChangedState(success);
                    if (success) {
                        builder.up();
                    } else {
                        builder.down();
                    }
                } else {
                    builder.unknown();
                }
            }
            catch (AccessTokenHealthNotSupportedException e) {
                logger.error("Health checks are unexpectedly not supported", (Throwable)e);
                builder.unknown();
            }
        }
    }

    protected void logInitialOrChangedState(boolean success) {
        Boolean previousSuccess = this.previousHealthSuccess;
        if (previousSuccess != null) {
            if (!previousSuccess.booleanValue() && success) {
                logger.info("Access-token-provider health transitioned to UP");
            } else if (previousSuccess.booleanValue() && !success) {
                logger.warn("Access-token-provider health transitioned to DOWN");
            }
        } else if (!success) {
            logger.warn("Access-token-provider health initialized to DOWN");
        } else {
            logger.info("Access-token-provider health initialized to UP");
        }
        this.previousHealthSuccess = success;
    }
}

