/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.client.spring;

import java.util.Map;
import org.entur.jwt.client.AccessTokenProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextStartedEvent;

public class EagerContextStartedListener
implements ApplicationListener<ContextStartedEvent> {
    private static Logger log = LoggerFactory.getLogger(EagerContextStartedListener.class);
    private final Map<String, AccessTokenProvider> providersById;

    public EagerContextStartedListener(Map<String, AccessTokenProvider> providersById) {
        this.providersById = providersById;
    }

    public void onApplicationEvent(ContextStartedEvent cse) {
        if (!this.providersById.isEmpty()) {
            log.info("Eagerly refreshing {} providers", (Object)this.providersById.size());
            for (Map.Entry<String, AccessTokenProvider> entry : this.providersById.entrySet()) {
                try {
                    entry.getValue().getAccessToken(false);
                }
                catch (Throwable e) {
                    log.warn("Unable to eagerly load JWT on context started for {}", (Object)entry.getKey());
                }
            }
        }
    }
}

