/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.client.spring;

import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.entur.jwt.client.AccessTokenProvider;
import org.entur.jwt.client.AccessTokenProviderBuilder;
import org.entur.jwt.client.ClientCredentials;
import org.entur.jwt.client.auth0.Auth0ClientCredentialsBuilder;
import org.entur.jwt.client.generic.GenericClientCredentialsBuilder;
import org.entur.jwt.client.keycloak.KeycloakClientCredentialsBuilder;
import org.entur.jwt.client.properties.AbstractJwtClientProperties;
import org.entur.jwt.client.properties.Auth0JwtClientProperties;
import org.entur.jwt.client.properties.GenericJwtClientProperties;
import org.entur.jwt.client.properties.JwtClientCache;
import org.entur.jwt.client.properties.JwtPreemptiveRefresh;
import org.entur.jwt.client.properties.KeycloakJwtClientProperties;
import org.entur.jwt.client.spring.SpringJwtClientProperties;

public abstract class JwtClientBeanDefinitionRegistryPostProcessorSupport<T> {
    protected T client;
    protected SpringJwtClientProperties rootProperties;

    public JwtClientBeanDefinitionRegistryPostProcessorSupport(T client, SpringJwtClientProperties properties) {
        this.client = client;
        this.rootProperties = properties;
    }

    public AccessTokenProvider newAuth0Instance(String key) {
        Auth0JwtClientProperties properties = this.rootProperties.getAuth0().get(key);
        ClientCredentials credentials = ((Auth0ClientCredentialsBuilder)((Auth0ClientCredentialsBuilder)((Auth0ClientCredentialsBuilder)((Auth0ClientCredentialsBuilder)((Auth0ClientCredentialsBuilder)((Auth0ClientCredentialsBuilder)((Auth0ClientCredentialsBuilder)Auth0ClientCredentialsBuilder.newInstance().withPort(properties.getPort())).withProtocol(properties.getProtocol())).withHost(properties.getHost())).withClientId(properties.getClientId())).withSecret(properties.getSecret())).withScope(properties.getScope())).withAudience(properties.getAudience())).build();
        return this.toAccessTokenProvider(this.client, (AbstractJwtClientProperties)properties, credentials, properties.isHealth());
    }

    public AccessTokenProvider newKeycloakInstance(String key) {
        KeycloakJwtClientProperties properties = this.rootProperties.getKeycloak().get(key);
        ClientCredentials credentials = ((KeycloakClientCredentialsBuilder)((KeycloakClientCredentialsBuilder)((KeycloakClientCredentialsBuilder)((KeycloakClientCredentialsBuilder)((KeycloakClientCredentialsBuilder)((KeycloakClientCredentialsBuilder)((KeycloakClientCredentialsBuilder)KeycloakClientCredentialsBuilder.newInstance().withPort(properties.getPort())).withProtocol(properties.getProtocol())).withHost(properties.getHost())).withClientId(properties.getClientId())).withSecret(properties.getSecret())).withScope(properties.getScope())).withAudience(properties.getAudience())).withRealm(properties.getRealm()).build();
        return this.toAccessTokenProvider(this.client, (AbstractJwtClientProperties)properties, credentials, properties.isHealth());
    }

    public AccessTokenProvider newGenericInstance(String key) {
        GenericJwtClientProperties properties = this.rootProperties.getGeneric().get(key);
        ClientCredentials credentials = ((GenericClientCredentialsBuilder)((GenericClientCredentialsBuilder)((GenericClientCredentialsBuilder)((GenericClientCredentialsBuilder)((GenericClientCredentialsBuilder)((GenericClientCredentialsBuilder)((GenericClientCredentialsBuilder)((GenericClientCredentialsBuilder)((GenericClientCredentialsBuilder)((GenericClientCredentialsBuilder)GenericClientCredentialsBuilder.newInstance().withPort(properties.getPort())).withProtocol(properties.getProtocol())).withHost(properties.getHost())).withClientId(properties.getClientId())).withSecret(properties.getSecret())).withScope(properties.getScope())).withAudience(properties.getAudience())).withIssuePath(properties.getIssuePath())).withRefreshPath(properties.getRefreshPath())).withRevokePath(properties.getRevokePath())).withAuthorizationHeader(Boolean.valueOf(properties.getClientCredentialsRequestFormat() == GenericJwtClientProperties.ClientCredentialsRequestFormat.AUTHORIZATION_HEADER)).build();
        return this.toAccessTokenProvider(this.client, (AbstractJwtClientProperties)properties, credentials, properties.isHealth());
    }

    private AccessTokenProvider toAccessTokenProvider(T client, AbstractJwtClientProperties properties, ClientCredentials credentials, boolean health) {
        AccessTokenProvider accessTokenProvider;
        JwtClientCache cache = properties.getCache();
        URL revokeUrl = credentials.getRevokeURL();
        URL refreshUrl = credentials.getRefreshURL();
        if (revokeUrl != null && refreshUrl != null) {
            accessTokenProvider = this.newStatefulUrlAccessTokenProvider(client, credentials.getIssueURL(), credentials.getParameters(), credentials.getHeaders(), refreshUrl, revokeUrl, credentials);
        } else if (revokeUrl == null && refreshUrl == null) {
            accessTokenProvider = this.newUrlAccessTokenProvider(client, credentials.getIssueURL(), credentials.getParameters(), credentials.getHeaders(), credentials);
        } else {
            throw new IllegalStateException("Expected neither or both refresh url and revoke url present");
        }
        AccessTokenProviderBuilder builder = new AccessTokenProviderBuilder(accessTokenProvider);
        builder.retrying(properties.isRetrying());
        if (cache != null && cache.isEnabled()) {
            builder.cached(cache.getMinimumTimeToLive(), TimeUnit.SECONDS, cache.getRefreshTimeout(), TimeUnit.SECONDS);
            JwtPreemptiveRefresh preemptiveRefresh = cache.getPreemptiveRefresh();
            if (preemptiveRefresh != null && preemptiveRefresh.isEnabled()) {
                builder.preemptiveCacheRefresh((long)preemptiveRefresh.getTimeToExpires(), TimeUnit.SECONDS, preemptiveRefresh.getExpiresConstraint(), preemptiveRefresh.getEager().isEnabled());
            } else {
                builder.preemptiveCacheRefresh(false);
            }
        } else {
            builder.cached(false);
        }
        builder.health(health);
        return builder.build();
    }

    protected abstract AccessTokenProvider newUrlAccessTokenProvider(T var1, URL var2, Map<String, Object> var3, Map<String, Object> var4, ClientCredentials var5);

    protected abstract AccessTokenProvider newStatefulUrlAccessTokenProvider(T var1, URL var2, Map<String, Object> var3, Map<String, Object> var4, URL var5, URL var6, ClientCredentials var7);
}

