/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.client.spring.actuate;

import org.entur.jwt.client.AccessTokenHealth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public abstract class AbstractJwtHealthIndicator
extends AbstractHealthIndicator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJwtHealthIndicator.class);
    private AccessTokenHealth previousHealth;
    protected final String name;

    protected AbstractJwtHealthIndicator(String name) {
        this.name = name;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        AccessTokenHealth health = this.refreshHealth();
        if (health != null) {
            this.logInitialOrChangedState(health);
            if (health.isSuccess()) {
                builder.up();
            } else {
                builder.down();
            }
            builder.withDetail("timestamp", (Object)health.getTimestamp());
        } else {
            builder.unknown();
        }
    }

    protected abstract AccessTokenHealth refreshHealth();

    protected void logInitialOrChangedState(AccessTokenHealth health) {
        AccessTokenHealth previousHealth = this.previousHealth;
        if (previousHealth != null) {
            if (!previousHealth.isSuccess() && health.isSuccess()) {
                logger.info("{} JWT health transitioned to UP", (Object)this.name);
            } else if (previousHealth.isSuccess() && !health.isSuccess()) {
                logger.warn("{} JWT health transitioned to DOWN", (Object)this.name);
            }
        } else if (!health.isSuccess()) {
            logger.info("{} JWT health initialized to DOWN", (Object)this.name);
        } else {
            logger.info("{} JWT health initialized to UP", (Object)this.name);
        }
        this.previousHealth = health;
    }

    public String getName() {
        return this.name;
    }
}

