/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.client.spring.actuate;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.entur.jwt.client.AccessTokenHealth;
import org.entur.jwt.client.AccessTokenHealthProvider;
import org.entur.jwt.client.spring.actuate.AbstractJwtHealthIndicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenProviderHealthIndicator
extends AbstractJwtHealthIndicator
implements Closeable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AccessTokenProviderHealthIndicator.class);
    private ExecutorService executor;
    private List<JwtHealthIndicator> healthIndicators = new ArrayList<JwtHealthIndicator>();
    private volatile CountDownLatch countDownLatch = new CountDownLatch(0);

    public AccessTokenProviderHealthIndicator(ExecutorService executor, String name) {
        super(name);
        this.executor = executor;
    }

    public void addHealthIndicators(String name, AccessTokenHealthProvider provider) {
        this.healthIndicators.add(new JwtHealthIndicator(name, provider));
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AccessTokenHealth refreshHealth() {
        long time = System.currentTimeMillis();
        ArrayList<JwtHealthIndicator> unhealthy = new ArrayList<JwtHealthIndicator>(this.healthIndicators.size());
        ArrayList<JwtHealthIndicator> healthy = new ArrayList<JwtHealthIndicator>(this.healthIndicators.size());
        for (JwtHealthIndicator healthIndicator : this.healthIndicators) {
            if (healthIndicator.isHealthy()) {
                healthy.add(healthIndicator);
                continue;
            }
            unhealthy.add(healthIndicator);
        }
        if (unhealthy.isEmpty()) {
            return new AccessTokenHealth(time, true);
        }
        AccessTokenProviderHealthIndicator accessTokenProviderHealthIndicator = this;
        synchronized (accessTokenProviderHealthIndicator) {
            if (this.isIdle()) {
                this.refreshHealth(healthy, unhealthy, time);
            } else {
                LOGGER.info("Previous JWT health refresh is still in progress ({} outstanding)", (Object)this.countDownLatch.getCount());
            }
        }
        return new AccessTokenHealth(time, false);
    }

    private void refreshHealth(List<JwtHealthIndicator> healthy, List<JwtHealthIndicator> unhealthy, long time) {
        this.countDownLatch = new CountDownLatch(unhealthy.size());
        if (this.healthIndicators.size() > 1) {
            StringBuilder builder = new StringBuilder();
            builder.append("Refreshing ");
            builder.append(unhealthy.size());
            builder.append(" unhealthy JWT sources (");
            for (JwtHealthIndicator defaultJwksHealthIndicator : unhealthy) {
                builder.append(defaultJwksHealthIndicator.getName());
                builder.append(", ");
            }
            builder.setLength(builder.length() - 2);
            builder.append(") in the background.");
            if (!healthy.isEmpty()) {
                builder.append(" The other ");
                builder.append(healthy.size());
                builder.append(" JWT sources (");
                for (JwtHealthIndicator defaultJwksHealthIndicator : healthy) {
                    builder.append(defaultJwksHealthIndicator.getName());
                    builder.append(", ");
                }
                builder.setLength(builder.length() - 2);
                builder.append(") are healthy.");
            }
            LOGGER.info(builder.toString());
        }
        for (JwtHealthIndicator indicator : unhealthy) {
            this.executor.submit(() -> {
                try {
                    AccessTokenProviderHealthIndicator.refresh(indicator, time);
                }
                finally {
                    this.countDownLatch.countDown();
                }
            });
        }
    }

    private static boolean refresh(JwtHealthIndicator indicator, long time) {
        LOGGER.info("Refresh {} JWT health", (Object)indicator.getName());
        AccessTokenHealth health = indicator.refreshHealth();
        if (health != null && health.isSuccess()) {
            LOGGER.info("{} JWT is now healthy (in {}ms)", (Object)indicator.getName(), (Object)(System.currentTimeMillis() - time));
            return true;
        }
        LOGGER.info("{} JWT remains unhealthy (in {}ms)", (Object)indicator.getName(), (Object)(System.currentTimeMillis() - time));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle() {
        AccessTokenProviderHealthIndicator accessTokenProviderHealthIndicator = this;
        synchronized (accessTokenProviderHealthIndicator) {
            return this.countDownLatch.getCount() == 0L;
        }
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    private static class JwtHealthIndicator {
        private final AccessTokenHealthProvider provider;
        private final String name;

        public JwtHealthIndicator(String name, AccessTokenHealthProvider provider) {
            this.name = name;
            this.provider = provider;
        }

        public AccessTokenHealth refreshHealth() {
            long time = System.currentTimeMillis();
            try {
                return this.provider.getHealth(true);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to refresh " + this.name + " JWT health status", (Throwable)e);
                return new AccessTokenHealth(time, false);
            }
        }

        public boolean isHealthy() {
            try {
                AccessTokenHealth health = this.provider.getHealth(false);
                return health != null && health.isSuccess();
            }
            catch (Exception e) {
                LOGGER.warn("Unable to get " + this.name + " JWT health status", (Throwable)e);
                return false;
            }
        }

        public String getName() {
            return this.name;
        }
    }
}

