/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.client.spring.classic;

import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.entur.jwt.client.properties.JwtClientProperties;
import org.entur.jwt.client.spring.JwtClientAutoConfiguration;
import org.entur.jwt.client.spring.classic.RestTemplateJwtClientBeanDefinitionRegistryPostProcessorSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={JwtClientProperties.class})
public class RestTemplateJwtClientAutoConfiguration
extends JwtClientAutoConfiguration {
    private static Logger log = LoggerFactory.getLogger(RestTemplateJwtClientAutoConfiguration.class);

    @Bean
    @Qualifier(value="jwtRestTemplate")
    public RestTemplate jwtRestTemplate(RestTemplateBuilder restTemplateBuilder, JwtClientProperties properties) {
        int connectTimeout = properties.getConnectTimeout();
        int readTimeout = properties.getReadTimeout();
        Long timeout = this.getTimeout(properties);
        if (timeout != null) {
            if ((long)connectTimeout > timeout) {
                throw new IllegalArgumentException("Connect timeout of " + connectTimeout + "s exceeds cache refresh time of " + timeout + "s");
            }
            if ((long)readTimeout > timeout) {
                throw new IllegalArgumentException("Read timeout of " + readTimeout + "s exceeds cache refresh time of " + timeout + "s");
            }
        }
        return restTemplateBuilder.requestFactory(() -> RestTemplateJwtClientAutoConfiguration.getHttpComponentsClientHttpRequestFactory(connectTimeout, readTimeout)).build();
    }

    private static HttpComponentsClientHttpRequestFactory getHttpComponentsClientHttpRequestFactory(int connectTimeout, int readTimeout) {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((long)connectTimeout, TimeUnit.SECONDS).setResponseTimeout((long)readTimeout, TimeUnit.SECONDS).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().disableCookieManagement().disableAuthCaching().disableAutomaticRetries().disableRedirectHandling().setDefaultRequestConfig(requestConfig).setConnectionReuseStrategy((a, b, c) -> false).build();
        factory.setHttpClient((HttpClient)httpClient);
        return factory;
    }

    @Bean
    public RestTemplateJwtClientBeanDefinitionRegistryPostProcessorSupport jwtClientBeanDefinitionRegistryPostProcessorSupport(@Qualifier(value="jwtRestTemplate") RestTemplate restTemplate, JwtClientProperties properties) {
        return new RestTemplateJwtClientBeanDefinitionRegistryPostProcessorSupport(restTemplate, properties);
    }
}

