/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.client.spring.classic;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.entur.jwt.client.AbstractUrlAccessTokenProvider;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class RestTemplateUrlAccessTokenProvider
extends AbstractUrlAccessTokenProvider<ResponseEntity<Resource>> {
    protected final RestTemplate restTemplate;

    protected static StringBuilder printResponseEntityHeadersIfPresent(ResponseEntity<?> c, String ... headerNames) {
        StringBuilder builder = new StringBuilder();
        HttpHeaders headers = c.getHeaders();
        for (String headerName : headerNames) {
            List value = headers.get((Object)headerName);
            if (value == null) continue;
            builder.append(headerName);
            builder.append(':');
            if (value.size() == 1) {
                builder.append((String)value.get(0));
            } else {
                builder.append(value);
            }
            builder.append(", ");
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 2);
        }
        return builder;
    }

    public RestTemplateUrlAccessTokenProvider(RestTemplate restTemplate, URL issueUrl, Map<String, Object> parameters, Map<String, Object> headers) {
        super(issueUrl, parameters, headers);
        this.restTemplate = restTemplate;
    }

    protected ResponseEntity<Resource> request(URL url, byte[] body, Map<String, Object> map) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            headers.set(entry.getKey(), entry.getValue().toString());
        }
        HttpEntity request = new HttpEntity((Object)body, (MultiValueMap)headers);
        try {
            URI uri = url.toURI();
            return this.restTemplate.exchange(uri, HttpMethod.POST, request, Resource.class);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        catch (RestClientException e) {
            throw new IOException(e);
        }
    }

    protected int getResponseStatusCode(ResponseEntity<Resource> response) throws IOException {
        return response.getStatusCodeValue();
    }

    protected InputStream getResponseContent(ResponseEntity<Resource> response) throws IOException {
        Resource body = (Resource)response.getBody();
        if (body != null) {
            return body.getInputStream();
        }
        throw new IOException("Empty body");
    }

    protected StringBuilder printHeadersIfPresent(ResponseEntity<Resource> c, String ... headerNames) {
        return RestTemplateUrlAccessTokenProvider.printResponseEntityHeadersIfPresent(c, headerNames);
    }

    public boolean supportsHealth() {
        return false;
    }
}

