/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.junit5.extention;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.entur.jwt.junit5.impl.AuthorizationServerImplementation;

public class AuthorizationServerTestContext {
    private Map<Annotation, List<AuthorizationServerImplementation>> authorizationServers;

    public AuthorizationServerTestContext(List<AuthorizationServerImplementation> list) {
        HashMap<Annotation, List<AuthorizationServerImplementation>> values = new HashMap<Annotation, List<AuthorizationServerImplementation>>();
        for (AuthorizationServerImplementation item : list) {
            ArrayList<AuthorizationServerImplementation> itemList = new ArrayList<AuthorizationServerImplementation>();
            itemList.add(item);
            values.put(item.getAnnotation(), itemList);
        }
        this.authorizationServers = values;
    }

    public List<AuthorizationServerImplementation> getAuthorizationServers(AuthorizationServerImplementation impl) {
        return this.authorizationServers.get(impl.getAnnotation());
    }

    public void add(AuthorizationServerImplementation impl) {
        List<AuthorizationServerImplementation> list = this.authorizationServers.get(impl.getAnnotation());
        if (list == null) {
            list = new ArrayList<AuthorizationServerImplementation>();
            this.authorizationServers.put(impl.getAnnotation(), list);
        }
        if (!list.contains(impl)) {
            list.add(impl);
        }
    }

    public Set<String> getServerNames() {
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<Annotation, List<AuthorizationServerImplementation>> entry : this.authorizationServers.entrySet()) {
            set.add(entry.getValue().get(0).getId());
        }
        return set;
    }
}

