/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.spring.test;

import org.entur.jwt.junit5.configuration.resolve.ResourceServerConfiguration;
import org.entur.jwt.junit5.configuration.resolve.ResourceServerConfigurationResolver;
import org.entur.jwt.spring.test.JwtEnvironmentResourceServerConfiguration;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.util.Assert;

public class SpringTestResourceServerConfigurationResolver
implements ResourceServerConfigurationResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{SpringExtension.class});

    public ResourceServerConfiguration resolve(ExtensionContext context) throws Exception {
        ApplicationContext applicationContext = SpringTestResourceServerConfigurationResolver.getApplicationContext(context);
        Environment environment = applicationContext.getEnvironment();
        return new JwtEnvironmentResourceServerConfiguration(environment, "entur.jwt.tenants", ".enabled");
    }

    public static ApplicationContext getApplicationContext(ExtensionContext context) {
        return SpringTestResourceServerConfigurationResolver.getTestContextManager(context).getTestContext().getApplicationContext();
    }

    protected static TestContextManager getTestContextManager(ExtensionContext context) {
        Assert.notNull((Object)context, (String)"ExtensionContext must not be null");
        Class testClass = context.getRequiredTestClass();
        ExtensionContext.Store store = SpringTestResourceServerConfigurationResolver.getStore(context);
        return (TestContextManager)store.get((Object)testClass, TestContextManager.class);
    }

    protected static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }
}

