/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.spring;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.entur.jwt.spring.CustomAuthenticationFailureHandler;
import org.entur.jwt.spring.CustomServerAuthenticationEntryPoint;
import org.entur.jwt.spring.JwtAutoConfiguration;
import org.entur.jwt.spring.auth0.properties.AuthorizationProperties;
import org.entur.jwt.spring.auth0.properties.CorsProperties;
import org.entur.jwt.spring.auth0.properties.PermitAll;
import org.entur.jwt.spring.auth0.properties.SecurityProperties;
import org.entur.jwt.spring.filter.JwtAuthenticationExceptionHandler;
import org.entur.jwt.spring.filter.JwtAuthenticationManager;
import org.entur.jwt.spring.filter.JwtAuthorityMapper;
import org.entur.jwt.spring.filter.JwtDetailsMapper;
import org.entur.jwt.spring.filter.JwtPrincipalMapper;
import org.entur.jwt.spring.filter.JwtServerAuthenticationConverter;
import org.entur.jwt.spring.filter.log.JwtMappedDiagnosticContextMapper;
import org.entur.jwt.spring.filter.resolver.JwtArgumentResolver;
import org.entur.jwt.verifier.JwtClaimExtractor;
import org.entur.jwt.verifier.JwtVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.reactive.CorsConfigurationSource;
import org.springframework.web.cors.reactive.CorsWebFilter;
import org.springframework.web.cors.reactive.UrlBasedCorsConfigurationSource;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;

@ConditionalOnProperty(name={"entur.jwt.enabled"}, havingValue="true")
@AutoConfigureAfter(value={JwtAutoConfiguration.class})
public class JwtWebFluxAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JwtWebFluxAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={JwtServerAuthenticationConverter.class})
    public <T> JwtServerAuthenticationConverter<T> auth(SecurityProperties properties, JwtVerifier<T> verifier, @Autowired(required=false) JwtMappedDiagnosticContextMapper<T> mdcMapper, JwtAuthorityMapper<T> authorityMapper, JwtClaimExtractor<T> extractor, JwtPrincipalMapper jwtPrincipalMapper, JwtDetailsMapper jwtDetailsMapper) {
        boolean tokenMustBePresent;
        AuthorizationProperties authorizationProperties = properties.getAuthorization();
        PermitAll permitAll = authorizationProperties.getPermitAll();
        boolean bl = tokenMustBePresent = authorizationProperties.isEnabled() && !permitAll.isActive();
        if (tokenMustBePresent) {
            log.info("Authentication with Json Web Token is required");
        } else {
            log.info("Authentication with Json Web Token is optional");
        }
        return new JwtServerAuthenticationConverter<T>(verifier, authorityMapper, mdcMapper, extractor, tokenMustBePresent, jwtDetailsMapper, jwtPrincipalMapper);
    }

    @Bean
    @ConditionalOnMissingBean(value={JwtAuthenticationExceptionHandler.class})
    public JwtAuthenticationExceptionHandler advice() {
        return new JwtAuthenticationExceptionHandler();
    }

    @Bean
    @ConditionalOnMissingBean(value={ReactiveAuthenticationManager.class})
    @ConditionalOnProperty(name={"entur.jwt.enabled"}, havingValue="true")
    public ReactiveAuthenticationManager reactiveAuthenticationManager() {
        return new JwtAuthenticationManager();
    }

    @Bean
    @ConditionalOnMissingBean(value={CustomAuthenticationFailureHandler.class})
    @ConditionalOnProperty(name={"entur.jwt.enabled"}, havingValue="true")
    public CustomAuthenticationFailureHandler customAuthenticationFailureHandler() {
        return new CustomAuthenticationFailureHandler();
    }

    @Bean
    @ConditionalOnMissingBean(value={CustomServerAuthenticationEntryPoint.class})
    @ConditionalOnProperty(name={"entur.jwt.enabled"}, havingValue="true")
    public CustomServerAuthenticationEntryPoint customServerAuthenticationEntryPoint() {
        return new CustomServerAuthenticationEntryPoint();
    }

    @Bean(value={"corsConfigurationSource"})
    @ConditionalOnProperty(name={"entur.cors.enabled"}, havingValue="true")
    public CorsWebFilter corsConfigurationSource(SecurityProperties oidcAuthProperties) {
        CorsProperties cors = oidcAuthProperties.getCors();
        if (cors.getMode().equals("api")) {
            return JwtWebFluxAutoConfiguration.getCorsConfiguration(cors);
        }
        if (!cors.getOrigins().isEmpty()) {
            throw new IllegalStateException("Expected empty hosts configuration for CORS mode '" + cors.getMode() + "'");
        }
        log.info("Disable CORS requests for webapp mode");
        return JwtWebFluxAutoConfiguration.getEmptyCorsConfiguration();
    }

    @Bean(value={"corsConfigurationSource"})
    @ConditionalOnProperty(name={"entur.security.cors.mode"}, havingValue="webapp")
    public CorsWebFilter corsConfigurationSourceForWebapp(SecurityProperties properties) {
        log.info("Disable CORS requests for webapp mode");
        return JwtWebFluxAutoConfiguration.getEmptyCorsConfiguration();
    }

    public static CorsWebFilter getEmptyCorsConfiguration() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowedOrigins(Collections.emptyList());
        config.setAllowedHeaders(Collections.emptyList());
        config.setAllowedMethods(Collections.emptyList());
        source.registerCorsConfiguration("/**", config);
        return new CorsWebFilter((CorsConfigurationSource)source);
    }

    public static CorsWebFilter getCorsConfiguration(CorsProperties properties) {
        List<String> defaultAllowedMethods = Arrays.asList("GET", "HEAD", "POST", "PUT", "DELETE", "PATCH", "OPTIONS");
        List<String> defaultAllowedHeaders = Collections.singletonList("*");
        List origins = properties.getOrigins();
        log.info("Enable CORS request with origins {}, methods {} and headers {} for API mode", new Object[]{properties.getOrigins(), properties.hasMethods() ? properties.getMethods() : "default (" + defaultAllowedMethods + ")", properties.hasHeaders() ? properties.getHeaders() : "default (" + defaultAllowedHeaders + ")"});
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowedOrigins(origins);
        if (properties.hasHeaders()) {
            config.setAllowedHeaders(properties.getHeaders());
        } else {
            config.setAllowedHeaders(defaultAllowedHeaders);
        }
        if (properties.hasMethods()) {
            config.setAllowedMethods(properties.getMethods());
        } else {
            config.setAllowedMethods(defaultAllowedMethods);
        }
        config.setMaxAge(Long.valueOf(86400L));
        config.setAllowCredentials(Boolean.valueOf(true));
        source.registerCorsConfiguration("/**", config);
        return new CorsWebFilter((CorsConfigurationSource)source);
    }

    @Configuration
    public static class DefaultEnturWebFluxConfigurer
    implements WebFluxConfigurer {
        private final JwtArgumentResolver resolver;

        @Autowired
        public DefaultEnturWebFluxConfigurer(JwtArgumentResolver resolver) {
            this.resolver = resolver;
        }

        public void configureArgumentResolvers(ArgumentResolverConfigurer configurer) {
            configurer.addCustomResolver(new HandlerMethodArgumentResolver[]{this.resolver});
        }
    }
}

