/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.spring.filter;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.entur.jwt.jwk.JwksClientException;
import org.entur.jwt.jwk.JwksException;
import org.entur.jwt.spring.filter.JwtAuthenticationServiceUnavailableException;
import org.entur.jwt.spring.filter.JwtAuthenticationToken;
import org.entur.jwt.spring.filter.JwtAuthorityMapper;
import org.entur.jwt.spring.filter.JwtDetailsMapper;
import org.entur.jwt.spring.filter.JwtPrincipalMapper;
import org.entur.jwt.spring.filter.log.JwtMappedDiagnosticContextMapper;
import org.entur.jwt.verifier.JwtClaimExtractor;
import org.entur.jwt.verifier.JwtClientException;
import org.entur.jwt.verifier.JwtException;
import org.entur.jwt.verifier.JwtVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class JwtServerAuthenticationConverter<T>
implements ServerAuthenticationConverter {
    public static final String BEARER = "Bearer ";
    private static final Logger log = LoggerFactory.getLogger(JwtServerAuthenticationConverter.class);
    private final JwtVerifier<T> verifier;
    private final JwtAuthorityMapper<T> authorityMapper;
    private final JwtMappedDiagnosticContextMapper<T> mdcMapper;
    private final JwtClaimExtractor<T> extractor;
    private final boolean required;
    private final JwtDetailsMapper detailsMapper;
    private final JwtPrincipalMapper principalMapper;

    public JwtServerAuthenticationConverter(JwtVerifier<T> verifier, JwtAuthorityMapper<T> authorityMapper, JwtMappedDiagnosticContextMapper<T> mdcMapper, JwtClaimExtractor<T> extractor, boolean required, JwtDetailsMapper detailsMapper, JwtPrincipalMapper principalMapper) {
        this.verifier = verifier;
        this.authorityMapper = authorityMapper;
        this.mdcMapper = mdcMapper;
        this.extractor = extractor;
        this.required = required;
        this.detailsMapper = detailsMapper;
        this.principalMapper = principalMapper;
    }

    public Mono<Authentication> convert(ServerWebExchange exchange) {
        return Mono.justOrEmpty((Object)exchange.getRequest().getHeaders().getFirst("Authorization")).switchIfEmpty(Mono.defer(() -> {
            if (!this.required) {
                return Mono.empty();
            }
            throw new BadCredentialsException("Expected token");
        })).mapNotNull(authHeader -> {
            String bearerToken = authHeader.substring(BEARER.length());
            try {
                Object token = this.verifier.verify(bearerToken);
                if (token == null) {
                    log.debug("Unable to verify token");
                    throw new BadCredentialsException("Unable to verify token");
                }
                List authorities = this.authorityMapper.getGrantedAuthorities(token);
                Map claims = this.extractor.getClaims(token);
                Serializable details = this.detailsMapper.getDetails((Object)exchange.getRequest(), claims);
                Serializable principal = this.principalMapper.getPrincipal(claims);
                JwtAuthenticationToken jwtToken = new JwtAuthenticationToken(claims, bearerToken, (Collection)authorities, principal, details);
                if (this.mdcMapper == null) return jwtToken;
                this.mdcMapper.addContext(token);
                try {
                    JwtAuthenticationToken jwtAuthenticationToken = jwtToken;
                    return jwtAuthenticationToken;
                }
                finally {
                    this.mdcMapper.removeContext(token);
                }
            }
            catch (JwksClientException | JwtClientException e) {
                log.debug("JWT verification failed due to {}", (Object)e.getMessage());
                throw new BadCredentialsException("Unable to verify token", e);
            }
            catch (JwksException | JwtException e) {
                log.warn("Unable to process token", e);
                throw new JwtAuthenticationServiceUnavailableException("Unable to process token", e);
            }
        });
    }
}

