/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.spring.filter.resolver;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.entur.jwt.spring.filter.JwtAuthenticationToken;
import org.entur.jwt.spring.filter.resolver.JwtArgumentResolverException;
import org.entur.jwt.spring.filter.resolver.TenantExpectedAuthenticationException;
import org.entur.jwt.spring.filter.resolver.UnexpectedJwtArgumentResolverResultException;
import org.springframework.core.MethodParameter;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class JwtArgumentResolver
implements HandlerMethodArgumentResolver {
    private final List<Class<?>> paramters;
    private final BiFunction<Map<String, Object>, Class<?>, ?> transformer;

    public JwtArgumentResolver(BiFunction<Map<String, Object>, Class<?>, ?> transformer, Class<?> ... parameters) {
        this(transformer, Arrays.asList(parameters));
    }

    public JwtArgumentResolver(BiFunction<Map<String, Object>, Class<?>, ?> transformer, List<Class<?>> parameters) {
        this.paramters = parameters;
        this.transformer = transformer;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return this.paramters.contains(parameter.getParameterType());
    }

    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext bindingContext, ServerWebExchange exchange) {
        return ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication).switchIfEmpty(Mono.defer(() -> {
            if (parameter.isOptional()) {
                return Mono.empty();
            }
            throw new TenantExpectedAuthenticationException("Expected " + JwtAuthenticationToken.class.getName() + " authorization, was none");
        })).map(authentication -> {
            if (authentication != null && !(authentication instanceof AnonymousAuthenticationToken)) {
                if (authentication instanceof JwtAuthenticationToken) {
                    Object tenant;
                    Class<?> resolved;
                    JwtAuthenticationToken token = (JwtAuthenticationToken)authentication;
                    Class target = parameter.getParameterType();
                    if (target.isAssignableFrom(resolved = (tenant = this.transformer.apply(token.getClaims(), target)).getClass())) {
                        return tenant;
                    }
                    throw new UnexpectedJwtArgumentResolverResultException("Unexpected type " + resolved.getName() + " for parameter type " + target.getName());
                }
                if (parameter.isOptional()) {
                    return Mono.empty();
                }
                throw new JwtArgumentResolverException("Expected " + JwtAuthenticationToken.class.getName() + " authorization, was " + authentication.getClass().getName());
            }
            if (parameter.isOptional()) {
                return Mono.empty();
            }
            throw new TenantExpectedAuthenticationException("Expected " + JwtAuthenticationToken.class.getName() + " authorization, was none");
        });
    }
}

