/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.spring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.entur.jwt.spring.Auth0JwtAuthorityEnricher;
import org.entur.jwt.spring.DefaultJwtAuthorityEnricher;
import org.entur.jwt.spring.JwkSourceMap;
import org.entur.jwt.spring.JwtAuthorityEnricher;
import org.entur.jwt.spring.JwtWebFluxAutoConfiguration;
import org.entur.jwt.spring.KeycloakJwtAuthorityEnricher;
import org.entur.jwt.spring.NoUserDetailsService;
import org.entur.jwt.spring.config.EnturAuthorizeHttpRequestsCustomizer;
import org.entur.jwt.spring.config.EnturOauth2ResourceServerCustomizer;
import org.entur.jwt.spring.properties.Auth0Flavour;
import org.entur.jwt.spring.properties.AuthorizationProperties;
import org.entur.jwt.spring.properties.Flavours;
import org.entur.jwt.spring.properties.JwtProperties;
import org.entur.jwt.spring.properties.KeycloakFlavour;
import org.entur.jwt.spring.properties.MdcProperties;
import org.entur.jwt.spring.properties.SecurityProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.method.configuration.EnableReactiveMethodSecurity;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.userdetails.MapReactiveUserDetailsService;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.header.XXssProtectionServerHttpHeadersWriter;
import org.springframework.security.web.server.savedrequest.NoOpServerRequestCache;
import org.springframework.security.web.server.savedrequest.ServerRequestCache;

@Configuration
@ConditionalOnExpression(value="${entur.authorization.enabled:true} || ${entur.jwt.enabled:true}")
@EnableConfigurationProperties(value={SecurityProperties.class})
@AutoConfigureAfter(value={JwtWebFluxAutoConfiguration.class})
public class JwtWebFluxSecurityAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JwtWebFluxSecurityAutoConfiguration.class);

    @Bean
    @ConditionalOnProperty(name={"entur.jwt.enabled"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={JwtAuthorityEnricher.class})
    public JwtAuthorityEnricher jwtAuthorityEnricher() {
        return new DefaultJwtAuthorityEnricher();
    }

    @Configuration
    @ConditionalOnMissingBean(name={"springSecurityFilterChain"})
    @ConditionalOnExpression(value="${entur.authorization.enabled:true} || ${entur.jwt.enabled:true}")
    @EnableWebFluxSecurity
    @EnableReactiveMethodSecurity
    public static class CompositeWebSecurityConfigurerAdapter {
        private SecurityProperties securityProperties;

        public CompositeWebSecurityConfigurerAdapter(SecurityProperties securityProperties) {
            this.securityProperties = securityProperties;
        }

        @Bean
        @ConditionalOnExpression(value="${entur.authorization.enabled:true} && !${entur.jwt.enabled:true}")
        public SecurityWebFilterChain securityWebFilterChain(ServerHttpSecurity http) throws Exception {
            log.info("Configure without JWT");
            AuthorizationProperties authorization = this.securityProperties.getAuthorization();
            if (authorization.isEnabled()) {
                http.authorizeExchange((Customizer)new EnturAuthorizeHttpRequestsCustomizer(authorization));
            }
            return CompositeWebSecurityConfigurerAdapter.getSecurityWebFilterChain(http);
        }

        @Bean
        @ConditionalOnExpression(value="${entur.jwt.enabled:true}")
        public SecurityWebFilterChain jwtSecurityWebFilterChain(ServerHttpSecurity http, JwkSourceMap jwkSourceMap, List<JwtAuthorityEnricher> jwtAuthorityEnrichers, List<OAuth2TokenValidator<Jwt>> jwtValidators) throws Exception {
            MdcProperties mdc;
            JwtProperties jwt;
            log.info("Configure with JWT");
            AuthorizationProperties authorization = this.securityProperties.getAuthorization();
            if (authorization.isEnabled()) {
                http.authorizeExchange((Customizer)new EnturAuthorizeHttpRequestsCustomizer(authorization));
            }
            if ((jwt = this.securityProperties.getJwt()).isEnabled()) {
                Flavours flavours = jwt.getFlavours();
                if (flavours.isEnabled()) {
                    KeycloakFlavour keycloak;
                    ArrayList<JwtAuthorityEnricher> enrichers = new ArrayList<JwtAuthorityEnricher>(jwtAuthorityEnrichers);
                    Auth0Flavour auth0 = flavours.getAuth0();
                    if (auth0.isEnabled()) {
                        enrichers.add((JwtAuthorityEnricher)new Auth0JwtAuthorityEnricher());
                    }
                    if ((keycloak = flavours.getKeycloak()).isEnabled()) {
                        enrichers.add((JwtAuthorityEnricher)new KeycloakJwtAuthorityEnricher());
                    }
                    jwtAuthorityEnrichers = enrichers;
                }
                http.oauth2ResourceServer((Customizer)new EnturOauth2ResourceServerCustomizer(jwkSourceMap.getJwkSources(), jwtAuthorityEnrichers, jwtValidators));
            }
            if ((mdc = jwt.getMdc()).isEnabled()) {
                throw new IllegalStateException("MDC not supported for webflux yet");
            }
            return CompositeWebSecurityConfigurerAdapter.getSecurityWebFilterChain(http);
        }

        private static SecurityWebFilterChain getSecurityWebFilterChain(ServerHttpSecurity http) {
            http.headers().xssProtection().headerValue(XXssProtectionServerHttpHeadersWriter.HeaderValue.ENABLED_MODE_BLOCK);
            return http.requestCache().requestCache((ServerRequestCache)NoOpServerRequestCache.getInstance()).and().csrf().disable().formLogin().disable().httpBasic().disable().logout().disable().cors(Customizer.withDefaults()).build();
        }

        @Bean
        @ConditionalOnMissingBean(value={MapReactiveUserDetailsService.class})
        public MapReactiveUserDetailsService reactiveUserDetailsService() {
            return new MapReactiveUserDetailsService(new HashMap());
        }

        @Bean
        @ConditionalOnMissingBean(value={UserDetailsService.class})
        public UserDetailsService userDetailsService() {
            return new NoUserDetailsService();
        }
    }

    @Configuration
    @ConditionalOnBean(name={"springSecurityFilterChain"})
    @ConditionalOnProperty(name={"entur.jwt.enabled"}, havingValue="true", matchIfMissing=true)
    public static class JwtConfigurationGuard {
        public JwtConfigurationGuard() {
            throw new IllegalStateException("JWT authentication does not work for custom spring filter chain. Add 'entur.jwt.enabled=false' or disable this starter using @SpringBootApplication(exclude = {JwtWebSecurityConfigurerAdapterAutoConfiguration.class}).");
        }
    }

    @Configuration
    @ConditionalOnBean(name={"springSecurityFilterChain"})
    @ConditionalOnProperty(name={"entur.authorization.enabled"}, havingValue="true", matchIfMissing=true)
    public static class AuthorizationConfigurationGuard {
        public AuthorizationConfigurationGuard() {
            throw new IllegalStateException("Authorization does not work for custom spring filter chain. Add 'entur.authorization.enabled=false' or disable this starter using @SpringBootApplication(exclude = {JwtWebSecurityConfigurerAdapterAutoConfiguration.class}).");
        }
    }
}

