/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.spring.config;

import org.entur.jwt.spring.properties.AuthorizationProperties;
import org.entur.jwt.spring.properties.HttpMethodMatcher;
import org.entur.jwt.spring.properties.MatcherConfiguration;
import org.entur.jwt.spring.properties.PermitAll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.web.server.ServerHttpSecurity;

public class EnturAuthorizeHttpRequestsCustomizer
implements Customizer<ServerHttpSecurity.AuthorizeExchangeSpec> {
    private static Logger log = LoggerFactory.getLogger(EnturAuthorizeHttpRequestsCustomizer.class);
    private final AuthorizationProperties authorizationProperties;

    public EnturAuthorizeHttpRequestsCustomizer(AuthorizationProperties authorizationProperties) {
        this.authorizationProperties = authorizationProperties;
    }

    public void customize(ServerHttpSecurity.AuthorizeExchangeSpec authorizeExchangeSpec) {
        log.info("Configure authorization filter");
        if (this.authorizationProperties.isEnabled()) {
            PermitAll permitAll = this.authorizationProperties.getPermitAll();
            if (permitAll.isActive()) {
                this.configurePermitAll(authorizeExchangeSpec, permitAll);
            }
            authorizeExchangeSpec.anyExchange().authenticated();
        }
    }

    protected void configurePermitAll(ServerHttpSecurity.AuthorizeExchangeSpec registry, PermitAll permitAll) {
        MatcherConfiguration mvcMatchers = permitAll.getMatcher();
        if (mvcMatchers.isActive()) {
            this.configurePermitAllMatchers(registry, mvcMatchers);
        }
    }

    protected void configurePermitAllMatchers(ServerHttpSecurity.AuthorizeExchangeSpec registry, MatcherConfiguration matchers) {
        if (matchers.hasPatterns()) {
            String[] patternsAsArray;
            for (String pattern : patternsAsArray = matchers.getPatternsAsArray()) {
                log.info("Permit all for " + pattern);
            }
            ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)registry.pathMatchers(patternsAsArray)).permitAll();
        }
        for (HttpMethodMatcher httpMethodMatcher : matchers.getMethod().getActiveMethods()) {
            String[] patternsAsArray;
            if (!httpMethodMatcher.isActive()) continue;
            for (String pattern : patternsAsArray = httpMethodMatcher.getPatternsAsArray()) {
                log.info("Permit all " + httpMethodMatcher.getVerb() + " for " + pattern);
            }
            ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)registry.pathMatchers(httpMethodMatcher.getVerb(), httpMethodMatcher.getPatternsAsArray())).permitAll();
        }
    }
}

