/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.spring.config;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.entur.jwt.spring.EnrichedJwtGrantedAuthoritiesConverter;
import org.entur.jwt.spring.JwtAuthorityEnricher;
import org.entur.jwt.spring.ReactiveJwtMonoConverter;
import org.entur.jwt.spring.config.IssuerAuthenticationManagerResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authentication.ReactiveAuthenticationManagerResolver;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.BadJwtException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;
import org.springframework.security.oauth2.jwt.NimbusReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.JwtIssuerReactiveAuthenticationManagerResolver;
import org.springframework.security.oauth2.server.resource.authentication.JwtReactiveAuthenticationManager;
import org.springframework.security.oauth2.server.resource.authentication.ReactiveJwtAuthenticationConverterAdapter;

public class EnturOauth2ResourceServerCustomizer
implements Customizer<ServerHttpSecurity.OAuth2ResourceServerSpec> {
    private static Logger LOGGER = LoggerFactory.getLogger(EnturOauth2ResourceServerCustomizer.class);
    private final Map<String, JWKSource> jwkSources;
    private final List<JwtAuthorityEnricher> jwtAuthorityEnrichers;
    private final List<OAuth2TokenValidator<Jwt>> jwtValidators;

    public EnturOauth2ResourceServerCustomizer(Map<String, JWKSource> jwkSources, List<JwtAuthorityEnricher> jwtAuthorityEnrichers, List<OAuth2TokenValidator<Jwt>> jwtValidators) {
        this.jwkSources = jwkSources;
        this.jwtAuthorityEnrichers = jwtAuthorityEnrichers;
        this.jwtValidators = jwtValidators;
    }

    public void customize(ServerHttpSecurity.OAuth2ResourceServerSpec configurer) {
        LOGGER.info("Customize " + this.jwkSources.size() + " issuers");
        HashMap<String, ReactiveAuthenticationManager> map = new HashMap<String, ReactiveAuthenticationManager>();
        for (Map.Entry<String, JWKSource> entry : this.jwkSources.entrySet()) {
            JWKSource jwkSource = entry.getValue();
            JWSVerificationKeySelector verificationKeySelector = new JWSVerificationKeySelector((Set)JWSAlgorithm.Family.SIGNATURE, jwkSource);
            DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
            jwtProcessor.setJWSKeySelector((JWSKeySelector)verificationKeySelector);
            jwtProcessor.setJWTClaimsSetVerifier((claims, context) -> {});
            ReactiveJwtMonoConverter reactiveConverter = new ReactiveJwtMonoConverter((DefaultJWTProcessor<SecurityContext>)jwtProcessor, verificationKeySelector);
            NimbusReactiveJwtDecoder decoder = new NimbusReactiveJwtDecoder((Converter)reactiveConverter);
            decoder.setJwtValidator(this.getJwtValidators(entry));
            JwtReactiveAuthenticationManager jwtReactiveAuthenticationManager = new JwtReactiveAuthenticationManager((ReactiveJwtDecoder)decoder);
            JwtAuthenticationConverter jwtAuthenticationConverter = new JwtAuthenticationConverter();
            jwtAuthenticationConverter.setJwtGrantedAuthoritiesConverter((Converter)new EnrichedJwtGrantedAuthoritiesConverter(this.jwtAuthorityEnrichers));
            jwtReactiveAuthenticationManager.setJwtAuthenticationConverter((Converter)new ReactiveJwtAuthenticationConverterAdapter((Converter)jwtAuthenticationConverter));
            map.put(entry.getKey(), (ReactiveAuthenticationManager)jwtReactiveAuthenticationManager);
        }
        IssuerAuthenticationManagerResolver issuer = new IssuerAuthenticationManagerResolver(map);
        JwtIssuerReactiveAuthenticationManagerResolver jwtIssuerAuthenticationManagerResolver = new JwtIssuerReactiveAuthenticationManagerResolver((ReactiveAuthenticationManagerResolver)issuer);
        configurer.authenticationManagerResolver((ReactiveAuthenticationManagerResolver)jwtIssuerAuthenticationManagerResolver);
    }

    private static <C extends SecurityContext> JWTClaimsSet createClaimsSet(JWTProcessor<C> jwtProcessor, JWT parsedToken, C context) {
        try {
            return jwtProcessor.process(parsedToken, context);
        }
        catch (BadJOSEException ex) {
            throw new BadJwtException("Failed to validate the token", (Throwable)ex);
        }
        catch (JOSEException ex) {
            throw new JwtException("Failed to validate the token", (Throwable)ex);
        }
    }

    private DelegatingOAuth2TokenValidator<Jwt> getJwtValidators(Map.Entry<String, JWKSource> entry) {
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(new JwtIssuerValidator(entry.getKey()));
        validators.addAll(this.jwtValidators);
        DelegatingOAuth2TokenValidator validator = new DelegatingOAuth2TokenValidator(validators);
        return validator;
    }
}

