/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.api;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.metamodel.util.LazyRef;
import org.apache.metamodel.util.Ref;
import org.apache.metamodel.util.SharedExecutorService;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.api.AnalyzerResultFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzerResultFutureImpl<R extends AnalyzerResult>
implements AnalyzerResultFuture<R> {
    private static final Logger logger = LoggerFactory.getLogger(AnalyzerResultFutureImpl.class);
    private static final long serialVersionUID = 1L;
    private final transient CountDownLatch _countDownLatch;
    private volatile transient List<AnalyzerResultFuture.Listener<? super R>> _listeners;
    private final String _name;
    private volatile R _result;
    private volatile RuntimeException _error;

    public AnalyzerResultFutureImpl(String name, final Ref<? extends R> resultRef) {
        this._name = name;
        this._countDownLatch = new CountDownLatch(1);
        this._result = null;
        this._error = null;
        SharedExecutorService.get().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    AnalyzerResultFutureImpl.this._result = (AnalyzerResult)resultRef.get();
                    if (AnalyzerResultFutureImpl.this._result == null && resultRef instanceof LazyRef) {
                        throw new RuntimeException(((LazyRef)resultRef).getError());
                    }
                    AnalyzerResultFutureImpl.this.onSuccess();
                }
                catch (RuntimeException e) {
                    AnalyzerResultFutureImpl.this._error = e;
                    AnalyzerResultFutureImpl.this.onError();
                }
                finally {
                    AnalyzerResultFutureImpl.this._countDownLatch.countDown();
                }
            }
        });
    }

    @Override
    public synchronized void addListener(AnalyzerResultFuture.Listener<? super R> listener) {
        if (this.isReady()) {
            if (this._error != null) {
                listener.onError(this._error);
            } else {
                listener.onSuccess(this._result);
            }
            return;
        }
        if (this._listeners == null) {
            this._listeners = new LinkedList<AnalyzerResultFuture.Listener<? super R>>();
        }
        this._listeners.add(listener);
    }

    @Override
    public synchronized void removeListener(AnalyzerResultFuture.Listener<R> listener) {
        if (this._listeners == null) {
            return;
        }
        this._listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void onSuccess() {
        if (this._listeners == null) {
            return;
        }
        try {
            for (AnalyzerResultFuture.Listener<R> listener : this._listeners) {
                try {
                    listener.onSuccess(this._result);
                }
                catch (Exception e) {
                    logger.warn("Unexpected exception while informing listener of success: {}", listener, (Object)e);
                }
            }
        }
        catch (Exception e) {
            logger.warn("Unexpected exception while iterating listeners on success", (Throwable)e);
        }
        finally {
            this._listeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void onError() {
        if (this._listeners == null) {
            return;
        }
        try {
            for (AnalyzerResultFuture.Listener<R> listener : this._listeners) {
                try {
                    listener.onError(this._error);
                }
                catch (Exception e) {
                    logger.warn("Unexpected exception while informing listener on error: {}", listener, (Object)e);
                }
            }
        }
        catch (Exception e) {
            logger.warn("Unexpected exception while iterating listeners on error", (Throwable)e);
        }
        finally {
            this._listeners = null;
        }
    }

    @Override
    public boolean isReady() {
        if (this._countDownLatch == null) {
            return true;
        }
        return this._countDownLatch.getCount() == 0L;
    }

    @Override
    public R get() {
        if (this._countDownLatch != null) {
            try {
                this._countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this._error != null) {
            throw this._error;
        }
        return this._result;
    }

    public String toString() {
        return "AnalyzerResultFuture[" + this._name + "]";
    }

    @Override
    public String getName() {
        return this._name;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        logger.info("Serialization requested, awaiting reference to load.");
        this.get();
        out.defaultWriteObject();
        logger.info("Serialization finished!");
    }
}

