/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.api;

import java.io.Serializable;
import java.util.Arrays;

public class OutputColumns
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String[] columnNames;
    private final Class<?>[] columnTypes;

    @Deprecated
    public OutputColumns(int columns) {
        this(columns, Object.class);
    }

    public OutputColumns(int columns, Class<?> columnType) {
        if (columns < 1) {
            throw new IllegalArgumentException("columns must be 1 or higher");
        }
        this.columnNames = new String[columns];
        this.columnTypes = new Class[columns];
        for (int i = 0; i < this.columnTypes.length; ++i) {
            this.columnTypes[i] = columnType;
        }
    }

    @Deprecated
    public OutputColumns(String[] columnNames) {
        this(columnNames, null);
    }

    public OutputColumns(String firstColumnName, String ... additionalColumnNames) {
        this(Object.class, firstColumnName, additionalColumnNames);
    }

    public OutputColumns(Class<?> columnType, String firstColumnName, String ... additionalColumnNames) {
        int length = additionalColumnNames.length + 1;
        this.columnNames = new String[length];
        this.columnTypes = new Class[length];
        this.columnNames[0] = firstColumnName;
        this.columnTypes[0] = columnType;
        for (int i = 0; i < additionalColumnNames.length; ++i) {
            this.columnNames[i + 1] = additionalColumnNames[i];
            this.columnTypes[i + 1] = columnType;
        }
    }

    public OutputColumns(String[] columnNames, Class<?>[] columnTypes) {
        if (columnNames == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        if (columnNames.length < 1) {
            throw new IllegalArgumentException("Column names length must be 1 or greater");
        }
        if (columnTypes == null) {
            columnTypes = new Class[columnNames.length];
        }
        if (columnNames.length != columnTypes.length) {
            throw new IllegalArgumentException("Column names and column types must have equal length");
        }
        this.columnNames = (String[])columnNames.clone();
        this.columnTypes = (Class[])columnTypes.clone();
    }

    public OutputColumns(Class<?> columnType, String[] columnNames) {
        if (columnNames == null || columnType == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        if (columnNames.length < 1) {
            throw new IllegalArgumentException("Column names length must be 1 or greater");
        }
        this.columnNames = (String[])columnNames.clone();
        this.columnTypes = new Class[columnNames.length];
        for (int i = 0; i < this.columnTypes.length; ++i) {
            this.columnTypes[i] = columnType;
        }
    }

    public Class<?> getColumnType(int index) {
        Class<?> cls = this.columnTypes[index];
        if (cls == null) {
            return Object.class;
        }
        return cls;
    }

    public void setColumnType(int index, Class<?> type) {
        this.columnTypes[index] = type;
    }

    public String getColumnName(int index) {
        return this.columnNames[index];
    }

    public void setColumnName(int index, String name) {
        this.columnNames[index] = name;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String toString() {
        return "OutputColumns" + Arrays.toString(this.columnNames);
    }
}

