/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.connection;

import java.util.Arrays;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;

public final class SchemaNavigator {
    private final DataContext dataContext;

    public SchemaNavigator(DataContext dataContext) {
        this.dataContext = dataContext;
    }

    public void refreshSchemas() {
        this.dataContext.refreshSchemas();
    }

    public Schema convertToSchema(String schemaName) {
        return this.dataContext.getSchemaByName(schemaName);
    }

    public Schema[] getSchemas() {
        return this.dataContext.getSchemas();
    }

    public Schema getDefaultSchema() {
        return this.dataContext.getDefaultSchema();
    }

    public Schema getSchemaByName(String name) {
        return this.dataContext.getSchemaByName(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Table convertToTable(String schemaName, String tableName) {
        Table table;
        Schema schema = schemaName == null ? this.getDefaultSchema() : this.getSchemaByName(schemaName);
        if (schema == null) {
            throw new IllegalArgumentException("Schema " + schemaName + " not found. Available schema names are: " + Arrays.toString(this.dataContext.getSchemaNames()));
        }
        if (tableName == null) {
            if (schema.getTableCount() != 1) throw new IllegalArgumentException("No table name specified, and multiple options exist. Available table names are: " + Arrays.toString(schema.getTableNames()));
            table = schema.getTables()[0];
        } else {
            table = schema.getTableByName(tableName);
        }
        if (table != null) return table;
        throw new IllegalArgumentException("Table not found. Available table names are: " + Arrays.toString(schema.getTableNames()));
    }

    public Column[] convertToColumns(String schemaName, String tableName, String[] columnNames) {
        if (columnNames == null) {
            return null;
        }
        if (columnNames.length == 0) {
            return new Column[0];
        }
        Table table = this.convertToTable(schemaName, tableName);
        Column[] columns = new Column[columnNames.length];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = table.getColumnByName(columnNames[i]);
        }
        return columns;
    }

    public Schema[] convertToSchemas(String[] schemaNames) {
        Schema[] result = new Schema[schemaNames.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.convertToSchema(schemaNames[i]);
        }
        return result;
    }

    public Table[] convertToTables(String[] tableNames) {
        Table[] result = new Table[tableNames.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.convertToTable(tableNames[i]);
        }
        return result;
    }

    public Table convertToTable(String tableName) {
        return this.dataContext.getTableByQualifiedLabel(tableName);
    }

    public Column[] convertToColumns(String[] columnNames) {
        Column[] result = new Column[columnNames.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.convertToColumn(columnNames[i]);
        }
        return result;
    }

    public Column convertToColumn(String columnName) {
        return this.dataContext.getColumnByQualifiedLabel(columnName);
    }
}

