/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.output;

import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Table;
import org.datacleaner.api.OutputDataStream;
import org.datacleaner.job.output.OutputDataStreamBuilder;
import org.datacleaner.job.output.PushOutputDataStream;

final class OutputDataStreamBuilderImpl
implements OutputDataStreamBuilder {
    private final String _name;
    private final MutableTable _table;

    public OutputDataStreamBuilderImpl(String name) {
        this._name = name;
        this._table = new MutableTable(name);
    }

    @Override
    public OutputDataStream toOutputDataStream() {
        if (this._table.getColumnCount() == 0) {
            throw new IllegalStateException("No columns defined in OutputDataStream '" + this._name + "'");
        }
        return new PushOutputDataStream(this._name, (Table)this._table);
    }

    @Override
    public OutputDataStreamBuilder likeTable(Table table) {
        Column[] newColumns;
        Column[] existingColumns;
        for (Column column : existingColumns = this._table.getColumns()) {
            this._table.removeColumn(column);
        }
        for (Column column : newColumns = table.getColumns()) {
            this.withColumn(column.getName(), column.getType());
        }
        return this;
    }

    @Override
    public OutputDataStreamBuilder withColumn(String name, ColumnType type) {
        int columnNumber = this._table.getColumnCount() + 1;
        MutableColumn column = new MutableColumn(name, type, (Table)this._table, columnNumber, Boolean.valueOf(true));
        this._table.addColumn((Column)column);
        return this;
    }
}

