/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.repository;

import org.datacleaner.repository.Repository;
import org.datacleaner.repository.RepositoryFolder;
import org.datacleaner.repository.RepositoryNode;

public abstract class AbstractRepositoryNode
implements RepositoryNode {
    private static final long serialVersionUID = 1L;

    @Override
    public final int compareTo(RepositoryNode o) {
        if (o == null) {
            return 1;
        }
        return this.getQualifiedPath().compareTo(o.getQualifiedPath());
    }

    @Override
    public String getQualifiedPath() {
        RepositoryFolder parent = this.getParent();
        if (parent == null || parent instanceof Repository) {
            return '/' + this.getName();
        }
        return parent.getQualifiedPath() + '/' + this.getName();
    }

    public final int hashCode() {
        return this.getQualifiedPath().hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof RepositoryNode) {
            String otherQualifiedPath = ((RepositoryNode)obj).getQualifiedPath();
            boolean equalPath = this.getQualifiedPath().equals(otherQualifiedPath);
            return equalPath;
        }
        return false;
    }

    public final String toString() {
        return this.getQualifiedPath();
    }
}

