/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.repository;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.metamodel.util.Action;
import org.apache.metamodel.util.Func;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.ResourceException;
import org.apache.metamodel.util.SerializableRef;
import org.datacleaner.repository.Repository;
import org.datacleaner.repository.RepositoryFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryFileResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(RepositoryFileResource.class);
    private final SerializableRef<RepositoryFile> _fileRef;
    private final String _qualifiedPath;

    public RepositoryFileResource(Repository repo, String qualifiedPath) {
        this._qualifiedPath = qualifiedPath;
        RepositoryFile file = (RepositoryFile)repo.getRepositoryNode(qualifiedPath);
        if (file == null) {
            logger.warn("Repository node did not exist: {}", (Object)qualifiedPath);
        }
        this._fileRef = new SerializableRef((Object)file);
    }

    public RepositoryFileResource(RepositoryFile file) {
        this._fileRef = new SerializableRef((Object)file);
        this._qualifiedPath = file.getQualifiedPath();
    }

    public RepositoryFileResource recreate(Repository repository) {
        return new RepositoryFileResource(repository, this._qualifiedPath);
    }

    public RepositoryFile getRepositoryFile() throws ResourceException {
        if (this._fileRef == null || this._fileRef.get() == null) {
            throw new ResourceException((Resource)this, "RepositoryFile '" + this._qualifiedPath + "' is not available since it was not serializable. The RepositoryFileResource instance can be recreated using a live repository and the qualified path of the file.");
        }
        return (RepositoryFile)this._fileRef.get();
    }

    public String getQualifiedPath() {
        return this._qualifiedPath;
    }

    public String toString() {
        return "RepositoryFileResource[" + this._qualifiedPath + "]";
    }

    public long getLastModified() {
        return this.getRepositoryFile().getLastModified();
    }

    public String getName() {
        return this.getRepositoryFile().getName();
    }

    public long getSize() {
        return this.getRepositoryFile().getSize();
    }

    public boolean isExists() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public InputStream read() throws ResourceException {
        return this.getRepositoryFile().readFile();
    }

    public void append(Action<OutputStream> appendAction) throws ResourceException {
        this.getRepositoryFile().writeFile(appendAction, true);
    }

    public void read(Action<InputStream> callback) throws ResourceException {
        this.getRepositoryFile().readFile(callback);
    }

    public <E> E read(Func<InputStream, E> callback) throws ResourceException {
        return this.getRepositoryFile().readFile(callback);
    }

    public void write(Action<OutputStream> callback) throws ResourceException {
        this.getRepositoryFile().writeFile(callback);
    }
}

