/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.codec;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.StringJoiner;
import javax.inject.Named;
import javax.xml.bind.DatatypeConverter;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.EncodingCategory;

@Named(value="Hash value")
@Description(value="It creates a hash from specified input. ")
@Categorized(value={EncodingCategory.class})
public class HashTransformer
implements Transformer {
    @Configured
    InputColumn<?>[] _columns;
    @Configured
    Algorithm _algorithm;

    public HashTransformer() {
        this._algorithm = Algorithm.SHA_512;
    }

    HashTransformer(InputColumn<?>[] columns, Algorithm algorithm) {
        this._columns = columns;
        this._algorithm = algorithm;
    }

    public OutputColumns getOutputColumns() {
        StringJoiner joiner = new StringJoiner(", ");
        for (InputColumn<?> column : this._columns) {
            joiner.add(column.getName());
        }
        return new OutputColumns(String.class, "Hash of " + joiner.toString(), new String[]{"Input length"});
    }

    public String[] transform(InputRow inputRow) {
        StringBuilder builder = new StringBuilder();
        int length = 0;
        for (InputColumn<?> column : this._columns) {
            Object value = inputRow.getValue(column);
            if (value == null || value.toString().isEmpty()) continue;
            String stringValue = value.toString();
            length += stringValue.length();
            builder.append(stringValue);
        }
        return new String[]{this.hash(builder.toString().getBytes()), String.valueOf(length)};
    }

    private String hash(byte[] input) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(this._algorithm.toString());
            messageDigest.update(input);
            byte[] hash = messageDigest.digest();
            return DatatypeConverter.printHexBinary((byte[])hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Algorithm used for hashing was not recognized. " + e.getMessage());
        }
    }

    static enum Algorithm {
        MD2,
        MD5,
        SHA,
        SHA_224,
        SHA_256,
        SHA_384,
        SHA_512;


        public String toString() {
            return this.name().replace('_', '-');
        }
    }
}

