/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.codec;

import com.google.common.html.HtmlEscapers;
import javax.inject.Named;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.EncodingCategory;
import org.datacleaner.data.MockInputColumn;

@Named(value="HTML encoder")
@Description(value="Encodes/escapes plain text into HTML content")
@Categorized(value={EncodingCategory.class})
public class HtmlEncoderTransformer
implements Transformer {
    @Configured
    InputColumn<String> column;

    public HtmlEncoderTransformer() {
    }

    public HtmlEncoderTransformer(MockInputColumn<String> column) {
        this();
        this.column = column;
    }

    public OutputColumns getOutputColumns() {
        return new OutputColumns(String.class, this.column.getName() + " (HTML encoded)", new String[0]);
    }

    public String[] transform(InputRow inputRow) {
        String value = (String)inputRow.getValue(this.column);
        if (value == null) {
            return new String[1];
        }
        String escaped = HtmlEscapers.htmlEscaper().escape(value);
        return new String[]{escaped};
    }
}

