/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.codec;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import javax.inject.Named;
import org.apache.metamodel.util.HasName;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.EncodingCategory;
import org.datacleaner.data.MockInputColumn;

@Named(value="URL encoder")
@Description(value="Encodes/escapes a URL or part of a URL")
@Categorized(value={EncodingCategory.class})
public class UrlEncoderTransformer
implements Transformer {
    @Configured
    InputColumn<String> column;
    @Configured
    TargetFormat targetFormat = TargetFormat.FRAGMENT;

    public UrlEncoderTransformer() {
    }

    public UrlEncoderTransformer(MockInputColumn<String> column) {
        this();
        this.column = column;
    }

    public OutputColumns getOutputColumns() {
        return new OutputColumns(String.class, this.column.getName() + " (URL encoded)", new String[0]);
    }

    public String[] transform(InputRow inputRow) {
        Escaper escaper;
        String value = (String)inputRow.getValue(this.column);
        if (value == null) {
            return new String[1];
        }
        switch (this.targetFormat) {
            case FORM_PARAMETER: {
                escaper = UrlEscapers.urlFormParameterEscaper();
                break;
            }
            case FRAGMENT: {
                escaper = UrlEscapers.urlFragmentEscaper();
                break;
            }
            case PATH_SEGMENT: {
                escaper = UrlEscapers.urlPathSegmentEscaper();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        String escaped = escaper.escape(value);
        return new String[]{escaped};
    }

    public static enum TargetFormat implements HasName
    {
        FORM_PARAMETER("Form parameter"),
        FRAGMENT("URL fragment"),
        PATH_SEGMENT("Path segment");

        private final String _name;

        private TargetFormat(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }
    }
}

