/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.codec;

import javax.inject.Named;
import org.apache.commons.lang.StringEscapeUtils;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.EncodingCategory;
import org.datacleaner.data.MockInputColumn;

@Named(value="XML decoder")
@Description(value="Decodes XML content into plain text")
@Categorized(value={EncodingCategory.class})
public class XmlDecoderTransformer
implements Transformer {
    @Configured
    InputColumn<String> column;

    public XmlDecoderTransformer() {
    }

    public XmlDecoderTransformer(MockInputColumn<String> column) {
        this();
        this.column = column;
    }

    public OutputColumns getOutputColumns() {
        return new OutputColumns(String.class, this.column.getName() + " (XML decoded)", new String[0]);
    }

    public String[] transform(InputRow inputRow) {
        String value = (String)inputRow.getValue(this.column);
        if (value == null) {
            return new String[1];
        }
        String unescaped = StringEscapeUtils.unescapeXml((String)value);
        return new String[]{unescaped};
    }
}

