/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.codec;

import com.google.common.escape.Escaper;
import com.google.common.xml.XmlEscapers;
import javax.inject.Named;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.EncodingCategory;
import org.datacleaner.data.MockInputColumn;

@Named(value="XML encoder")
@Description(value="Encodes/escapes plain text into XML content")
@Categorized(value={EncodingCategory.class})
public class XmlEncoderTransformer
implements Transformer {
    @Configured
    InputColumn<String> column;
    @Configured
    TargetFormat targetFormat = TargetFormat.Content;

    public XmlEncoderTransformer() {
    }

    public XmlEncoderTransformer(MockInputColumn<String> column) {
        this();
        this.column = column;
    }

    public OutputColumns getOutputColumns() {
        return new OutputColumns(String.class, this.column.getName() + " (XML encoded)", new String[0]);
    }

    public String[] transform(InputRow inputRow) {
        String value = (String)inputRow.getValue(this.column);
        if (value == null) {
            return new String[1];
        }
        Escaper escaper = this.targetFormat == TargetFormat.Content ? XmlEscapers.xmlContentEscaper() : XmlEscapers.xmlAttributeEscaper();
        String escaped = escaper.escape(value);
        return new String[]{escaped};
    }

    public static enum TargetFormat {
        Content,
        Attribute;

    }
}

