/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.numbers;

import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Named;
import org.apache.metamodel.util.HasName;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.Initialize;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.NumbersCategory;

@Named(value="Generate ID")
@Description(value="Generates a unique and sequential record ID")
@Categorized(value={NumbersCategory.class})
public class GenerateIdTransformer
implements Transformer {
    private final AtomicLong _counter;
    @Configured
    @Description(value="A type of ID which will be generated for each record in scope. Current options: sequential numbers or row number.")
    IdType idType = IdType.SEQUENCE;
    @Configured
    @Description(value="A column which represent the scope for which the ID will be generated. If eg. a source column is selected, an ID will be generated for each source record. If a transformed column is selected, an ID will be generated for each record generated that has this column.")
    InputColumn<?> columnInScope;
    @Configured
    @Description(value="The row number offset. This is often used to insert into a database with existing sequential IDs. Since the transformer increments before inserting, an offset of e.g. 100 would make the first newly inserted ID 101.")
    long offset = 0L;

    public GenerateIdTransformer() {
        this._counter = new AtomicLong();
    }

    @Initialize
    public void init() {
        this._counter.set(this.offset);
    }

    public OutputColumns getOutputColumns() {
        return new OutputColumns(Number.class, "Generated ID", new String[0]);
    }

    public Number[] transform(InputRow inputRow) {
        long id = IdType.ROW_NUMBER == this.idType ? inputRow.getId() : this._counter.incrementAndGet();
        return new Number[]{id};
    }

    public static enum IdType implements HasName
    {
        SEQUENCE("Sequence"),
        ROW_NUMBER("Row number");

        private final String name;

        private IdType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

