/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.numbers;

import javax.inject.Named;
import org.apache.metamodel.util.HasName;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.DateAndTimeCategory;

@Named(value="Generate timestamp")
@Description(value="Generates a timestamp representing the millisecond or nanosecond of processing the record")
@Categorized(value={DateAndTimeCategory.class})
public class GenerateTimestampTransformer
implements Transformer {
    @Configured
    @Description(value="A column which represent the scope for which the ID will be generated. If eg. a source column is selected, an ID will be generated for each source record. If a transformed column is selected, an ID will be generated for each record generated that has this column.")
    InputColumn<?> columnInScope;
    @Configured
    Unit unit = Unit.SECOND;

    public OutputColumns getOutputColumns() {
        return new OutputColumns(Long.class, "Generated timestamp", new String[0]);
    }

    public Long[] transform(InputRow inputRow) {
        long result = this.unit == Unit.NANOSECOND ? System.nanoTime() : (this.unit == Unit.SECOND ? System.currentTimeMillis() / 1000L : System.currentTimeMillis());
        return new Long[]{result};
    }

    public static enum Unit implements HasName
    {
        SECOND("Second"),
        MILLISECOND("Millisecond"),
        NANOSECOND("Nanosecond");

        private final String _name;

        private Unit(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }
    }
}

