/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.numbers;

import java.util.UUID;
import javax.inject.Named;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.NumbersCategory;

@Named(value="Generate UUID")
@Description(value="Generates a universally unique ID")
@Categorized(value={NumbersCategory.class})
public class GenerateUUIDTransformer
implements Transformer {
    @Configured
    @Description(value="A column which represent the scope for which the ID will be generated. If eg. a source column is selected, an ID will be generated for each source record. If a transformed column is selected, an ID will be generated for each record generated that has this column.")
    InputColumn<?> columnInScope;
    @Configured(required=false, order=10)
    String prefix;
    @Configured(required=false, order=11)
    String postfix;

    public OutputColumns getOutputColumns() {
        return new OutputColumns(String.class, "Generated UUID", new String[0]);
    }

    public String[] transform(InputRow inputRow) {
        String uuid = UUID.randomUUID().toString();
        String result = (this.prefix == null ? "" : this.prefix) + uuid + (this.postfix == null ? "" : this.postfix);
        return new String[]{result};
    }
}

