/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.numbers;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.inject.Named;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.NumberProperty;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.NumbersCategory;

@Named(value="Increment number")
@Description(value="Increment an id, a version or any other number.")
@Categorized(value={NumbersCategory.class})
public class IncrementNumberTransformer
implements Transformer {
    @Configured
    InputColumn<Number> _number;
    @Configured
    @NumberProperty(zero=false)
    int _increment = 1;

    public OutputColumns getOutputColumns() {
        return new OutputColumns(String.class, this._number.getName() + " (incremented)", new String[0]);
    }

    public Number[] transform(InputRow row) {
        Number number = (Number)row.getValue(this._number);
        if (number != null) {
            number = number instanceof Integer || number instanceof Short || number instanceof Byte ? (Number)(number.intValue() + this._increment) : (Number)(number instanceof Long ? (Number)(number.longValue() + (long)this._increment) : (Number)(number instanceof Float ? (Number)Float.valueOf(number.floatValue() + (float)this._increment) : (Number)(number instanceof BigDecimal ? ((BigDecimal)number).add(new BigDecimal(this._increment)) : (number instanceof BigInteger ? ((BigInteger)number).add(new BigInteger("" + this._increment)) : Double.valueOf(number.doubleValue() + (double)this._increment)))));
        }
        return new Number[]{number};
    }
}

