/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.numbers;

import javax.inject.Named;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.NumberProperty;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.NumbersCategory;

@Named(value="Round number")
@Description(value="Transformation for rounding a number, typically to the nearest integer, nearest ten, hundred or thousand.")
@Categorized(value={NumbersCategory.class})
public class RoundNumberTransformer
implements Transformer {
    @Configured
    InputColumn<Number> _number;
    @Configured
    @Description(value="Defines the factor of rounding. A factor of 1 will round to the nearest integer. A factor of 1000 will round the number to the nearest thousand.")
    @NumberProperty(zero=false, positive=true, negative=false)
    int _roundFactor = 1;

    public OutputColumns getOutputColumns() {
        return new OutputColumns(String.class, this._number.getName() + " (rounded)", new String[0]);
    }

    public Integer[] transform(InputRow row) {
        Number number = (Number)row.getValue(this._number);
        if (number != null) {
            number = Math.round(number.doubleValue() / (double)this._roundFactor) * (long)this._roundFactor;
            number = number.intValue();
        }
        return new Integer[]{(Integer)number};
    }
}

