/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.transform;

import javax.inject.Named;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.TextCategory;

@Named(value="Concatenator")
@Description(value="Concatenate several column values into one.")
@Categorized(value={TextCategory.class})
public class ConcatenatorTransformer
implements Transformer {
    @Configured
    InputColumn<?>[] columns;
    @Configured(required=false)
    @Description(value="A string to separate the concatenated values")
    String separator;

    public ConcatenatorTransformer(String separator, InputColumn<?>[] columns) {
        this.separator = separator;
        this.columns = columns;
    }

    public ConcatenatorTransformer() {
    }

    public OutputColumns getOutputColumns() {
        StringBuilder sb = new StringBuilder("Concat of ");
        for (int i = 0; i < this.columns.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(this.columns[i].getName());
            if (i != 4) continue;
            sb.append("...");
            break;
        }
        return new OutputColumns(String.class, sb.toString(), new String[0]);
    }

    public String[] transform(InputRow inputRow) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < this.columns.length; ++i) {
            InputColumn<?> column = this.columns[i];
            Object value = inputRow.getValue(column);
            if (value == null || "".equals(value)) continue;
            if (!first && this.separator != null) {
                sb.append(this.separator);
            }
            sb.append(value);
            first = false;
        }
        return new String[]{sb.toString()};
    }
}

