/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.transform;

import java.util.Date;
import javax.inject.Named;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.DateAndTimeCategory;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Years;

@Named(value="Date to age")
@Description(value="Turn a Date-column into columns of age (both in years and in days).")
@Categorized(value={DateAndTimeCategory.class})
public class DateToAgeTransformer
implements Transformer {
    public static final String PROPERTY_DATE_COLUMN = "Date column";
    public static final String OUTPUT_COLUMN_AGE_DAYS = "Age in days";
    public static final String OUTPUT_COLUMN_AGE_YEARS = "Age in years";
    @Configured(value="Date column")
    InputColumn<Date> dateColumn;
    private Date today = new Date();

    public OutputColumns getOutputColumns() {
        return new OutputColumns(Integer.class, OUTPUT_COLUMN_AGE_DAYS, new String[]{OUTPUT_COLUMN_AGE_YEARS});
    }

    public Integer[] transform(InputRow inputRow) {
        Integer[] result = new Integer[2];
        Date date = (Date)inputRow.getValue(this.dateColumn);
        if (date != null) {
            long diffMillis = this.today.getTime() - date.getTime();
            int diffDays = (int)(diffMillis / 86400000L);
            result[0] = diffDays;
            int diffYears = Years.yearsBetween((ReadableInstant)new DateTime((Object)date), (ReadableInstant)new DateTime((Object)this.today)).getYears();
            result[1] = diffYears;
        }
        return result;
    }

    public void setToday(Date today) {
        this.today = today;
    }

    public void setDateColumn(InputColumn<Date> dateColumn) {
        this.dateColumn = dateColumn;
    }
}

