/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.transform;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.inject.Named;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.DateAndTimeCategory;

@Named(value="Format date")
@Description(value="Allows you to format a date as a string by applying your own date format.")
@Categorized(value={DateAndTimeCategory.class})
public class FormatDateTransformer
implements Transformer {
    @Configured(value="Date")
    InputColumn<Date> dateColumn;
    @Configured
    String dateFormat = "yyyy-MM-dd HH:mm:ss";

    public OutputColumns getOutputColumns() {
        return new OutputColumns(String.class, this.dateColumn.getName() + " (formatted)", new String[0]);
    }

    public String[] transform(InputRow inputRow) {
        Date date = (Date)inputRow.getValue(this.dateColumn);
        if (date == null) {
            return new String[]{null};
        }
        SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
        return new String[]{format.format(date)};
    }
}

