/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.transform;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Named;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Converter;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.api.Validate;
import org.datacleaner.components.categories.TextCategory;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.job.builder.ComponentBuilder;
import org.datacleaner.util.convert.MapStringToStringConverter;
import org.datacleaner.util.convert.SerializationStringEscaper;
import org.datacleaner.util.convert.StringConverter;

@Named(value="Plain search/replace")
@Description(value="Search and replace text in String values.")
@Categorized(value={TextCategory.class})
public class PlainSearchReplaceTransformer
implements Transformer {
    private static final String REPLACEMENTS_PROPERTY_NAME = "Replacements";
    private static final String REPLACEMENT_STRING_PROPERTY_NAME = "Replacement string";
    private static final String SEARCH_STRING_PROPERTY_NAME = "Search string";
    private static final String CASE_SENSITIVE_PROPERTY_NAME = "Case sensitive";
    @Configured(value="Value", order=1)
    InputColumn<String> valueColumn;
    @Configured(order=2)
    @Description(value="A mapping of strings to do replacements with.")
    Map<String, String> replacements;
    @Configured(order=3)
    @Description(value="Replace the entire string when the search string is found.")
    boolean replaceEntireString = false;
    @Configured(value="Case sensitive", order=4)
    @Description(value="Case sensitivity mode. ")
    boolean caseSensitive = true;

    public static void processRemovedProperties(ComponentBuilder builder, StringConverter stringConverter, ComponentDescriptor<?> descriptor, Map<String, String> removedProperties) {
        if (removedProperties.containsKey(SEARCH_STRING_PROPERTY_NAME) && removedProperties.containsKey(REPLACEMENT_STRING_PROPERTY_NAME)) {
            ConfiguredPropertyDescriptor configuredProperty = descriptor.getConfiguredProperty(REPLACEMENTS_PROPERTY_NAME);
            Converter customConverter = configuredProperty.createCustomConverter();
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put(SerializationStringEscaper.unescape((String)removedProperties.get(SEARCH_STRING_PROPERTY_NAME)), SerializationStringEscaper.unescape((String)removedProperties.get(REPLACEMENT_STRING_PROPERTY_NAME)));
            Object value = stringConverter.deserialize(new MapStringToStringConverter().toString(replacements), configuredProperty.getType(), customConverter);
            builder.setConfiguredProperty(configuredProperty, value);
        }
    }

    public static boolean isRemovedProperty(ComponentDescriptor<?> descriptor, String name) {
        return SEARCH_STRING_PROPERTY_NAME.equals(name) || REPLACEMENT_STRING_PROPERTY_NAME.equals(name);
    }

    @Validate
    public void validate() {
        for (Map.Entry<String, String> entry : this.replacements.entrySet()) {
            String searchString = entry.getKey();
            if (Strings.isNullOrEmpty((String)searchString)) {
                throw new IllegalArgumentException("Search string cannot be empty");
            }
            String replacementString = entry.getValue();
            if (this.replaceEntireString || replacementString.indexOf(searchString) == -1) continue;
            throw new IllegalArgumentException("Replacement string cannot contain the search string (implies an infinite replacement loop)");
        }
    }

    public OutputColumns getOutputColumns() {
        return new OutputColumns(String.class, this.valueColumn.getName() + " (search/replaced)", new String[0]);
    }

    public String[] transform(InputRow row) {
        String[] result = new String[1];
        String value = (String)row.getValue(this.valueColumn);
        if (value != null) {
            result[0] = this.replaceEntireString ? this.replaceEntireString(value) : this.replaceFirstOccurrence(value);
        }
        return result;
    }

    private String replaceEntireString(String value) {
        for (Map.Entry<String, String> entry : this.replacements.entrySet()) {
            String replacementString = entry.getValue();
            String searchString = entry.getKey();
            if (!(this.caseSensitive ? value.contains(searchString) : value.toLowerCase().contains(searchString.toLowerCase()))) continue;
            return replacementString;
        }
        return value;
    }

    private String replaceFirstOccurrence(String value) {
        String result = value;
        for (Map.Entry<String, String> entry : this.replacements.entrySet()) {
            String replacementString = entry.getValue();
            String searchString = entry.getKey();
            Pattern pattern = this.caseSensitive ? Pattern.compile(searchString) : Pattern.compile(searchString, 2);
            result = pattern.matcher(result).replaceAll(replacementString);
        }
        return result;
    }

    public void setReplacements(Map<String, String> replacements) {
        this.replacements = replacements;
    }

    public void setReplaceEntireString(boolean replaceEntireString) {
        this.replaceEntireString = replaceEntireString;
    }
}

