/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.transform;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import org.apache.metamodel.util.HasName;
import org.datacleaner.api.Alias;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.ExternalDocumentation;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.OutputRowCollector;
import org.datacleaner.api.Provided;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.TextCategory;

@Named(value="Regex parser")
@Description(value="Parses strings using a regular expression and transforms it into substrings based on regex groups.A few examples:<ul><li>Match 3-dimensional size specification (e.g. '42x61x3') anywhere in a string:<blockquote>.*(\\d+)x(\\d+)x(\\d+).*</blockquote></li><li>Match two words:<blockquote>(\\w+) (\\w+)</blockquote></li><li>Match a hash-sign and 3 pairs of hexadecimal digits (using pseudo-characters of Java regular expressions):<blockquote>\\#?(\\p{XDigit}{2})(\\p{XDigit}{2})(\\p{XDigit}{2})</blockquote></li></ul>")
@ExternalDocumentation(value={@ExternalDocumentation.DocumentationLink(title="Regex parsing with DataCleaner", url="https://www.youtube.com/watch?v=VA6dw5Nv2AM", type=ExternalDocumentation.DocumentationType.VIDEO, version="3.0"), @ExternalDocumentation.DocumentationLink(title="Java Tutorials: Regular Expressions Lesson", url="https://docs.oracle.com/javase/tutorial/essential/regex/", type=ExternalDocumentation.DocumentationType.TECH, version="3.0")})
@Categorized(value={TextCategory.class})
public class RegexParserTransformer
implements Transformer {
    @Configured(value="Value")
    @Alias(value={"Column"})
    InputColumn<String> column;
    @Configured
    @Description(value="A regular expression containing group tokens, marked by parantheses.\nExample: ([a-z]+)_(\\d*)")
    Pattern pattern;
    @Configured
    @Description(value="The expression-and-value matching mode employed")
    Mode mode = Mode.FULL_MATCH;
    @Provided
    OutputRowCollector outputRowCollector;

    public OutputColumns getOutputColumns() {
        String[] columns = new String[this.pattern.matcher("").groupCount()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = this.column.getName() + " (group " + (i + 1) + ")";
        }
        return new OutputColumns(String.class, this.column.getName() + " (matched part)", columns);
    }

    public String[] transform(InputRow inputRow) {
        boolean match;
        Matcher matcher;
        String value = (String)inputRow.getValue(this.column);
        if (value == null) {
            matcher = this.pattern.matcher("");
            match = false;
        } else {
            matcher = this.pattern.matcher(value);
            switch (this.mode) {
                case FULL_MATCH: {
                    match = matcher.matches();
                    break;
                }
                case FIND_FIRST: 
                case FIND_ALL: {
                    match = matcher.find();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        String[] result = new String[matcher.groupCount() + 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = match ? matcher.group(i) : null;
        }
        if (this.mode == Mode.FIND_ALL) {
            while (matcher.find()) {
                Object[] nextResult = new Object[matcher.groupCount() + 1];
                for (int i = 0; i < nextResult.length; ++i) {
                    nextResult[i] = matcher.group(i);
                }
                this.outputRowCollector.putValues(nextResult);
            }
        }
        return result;
    }

    public static enum Mode implements HasName
    {
        FIND_FIRST("Find first match"),
        FIND_ALL("Find all matches"),
        FULL_MATCH("Match the complete value");

        private final String _name;

        private Mode(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }
    }
}

