/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.transform;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.ExternalDocumentation;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.PatternProperty;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.TextCategory;

@Named(value="Regex search/replace")
@Description(value="Search and replace text in String values using regular expressions.")
@ExternalDocumentation(value={@ExternalDocumentation.DocumentationLink(title="Java Tutorials: Regular Expressions Lesson", url="https://docs.oracle.com/javase/tutorial/essential/regex/", type=ExternalDocumentation.DocumentationType.TECH, version="3.0")})
@Categorized(value={TextCategory.class})
public class RegexSearchReplaceTransformer
implements Transformer {
    @Configured(value="Value", order=1)
    InputColumn<String> valueColumn;
    @Configured(order=2)
    @Description(value="Regular expression pattern used for searching.\nExample: 'Mr\\. (\\w+)'")
    Pattern searchPattern;
    @Configured(order=3)
    @Description(value="Regular expression pattern used for replacement.\nExample: 'Mister $1'")
    @PatternProperty(emptyString=true)
    Pattern replacementPattern = Pattern.compile("");

    public OutputColumns getOutputColumns() {
        return new OutputColumns(String.class, this.valueColumn.getName() + " (replaced '" + this.searchPattern.pattern() + "')", new String[0]);
    }

    public String[] transform(InputRow row) {
        String replacedString;
        String[] result = new String[1];
        String value = (String)row.getValue(this.valueColumn);
        if (value == null) {
            return result;
        }
        Matcher matcher = this.searchPattern.matcher(value);
        result[0] = replacedString = matcher.replaceAll(this.replacementPattern.pattern());
        return result;
    }
}

