/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.transform;

import javax.inject.Named;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.TextCategory;
import org.datacleaner.util.CharIterator;

@Named(value="Remove unwanted characters")
@Description(value="Removes characters from strings that are not wanted. Use it to cleanse codes and identifiers that may have additional dashes, punctuations, unwanted letters etc.")
@Categorized(value={TextCategory.class})
public class RemoveUnwantedCharsTransformer
implements Transformer {
    @Configured
    InputColumn<String> column;
    @Configured(order=1)
    boolean removeWhitespaces = true;
    @Configured(order=2)
    boolean removeLetters = true;
    @Configured(order=3)
    boolean removeDigits = false;
    @Configured(order=4)
    @Description(value="Remove additional signs, such as dashes, punctuations, slashes and more?")
    boolean removeSigns = true;

    public RemoveUnwantedCharsTransformer() {
    }

    public RemoveUnwantedCharsTransformer(InputColumn<String> inputColumn) {
        this.column = inputColumn;
    }

    public OutputColumns getOutputColumns() {
        return new OutputColumns(String.class, this.column.getName() + " (cleansed\u00df)", new String[0]);
    }

    public Object[] transform(InputRow row) {
        String value = (String)row.getValue(this.column);
        return this.transform(value);
    }

    public Object[] transform(String value) {
        if (value == null) {
            return new Object[1];
        }
        CharIterator it = new CharIterator((CharSequence)value);
        while (it.hasNext()) {
            it.next();
            if (it.isWhitespace()) {
                if (!this.removeWhitespaces) continue;
                it.remove();
                continue;
            }
            if (it.isLetter()) {
                if (!this.removeLetters) continue;
                it.remove();
                continue;
            }
            if (it.isDigit()) {
                if (!this.removeDigits) continue;
                it.remove();
                continue;
            }
            if (!this.removeSigns) continue;
            it.remove();
        }
        return new Object[]{it.toString()};
    }
}

