/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.transform;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import org.apache.metamodel.util.HasName;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.Initialize;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Provided;
import org.datacleaner.api.Transformer;
import org.datacleaner.api.Validate;
import org.datacleaner.components.categories.TextCategory;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.reference.Dictionary;
import org.datacleaner.reference.DictionaryConnection;

@Named(value="Text case transformer")
@Description(value="Modifies the text case/capitalization of Strings.")
@Categorized(value={TextCategory.class})
public class TextCaseTransformer
implements Transformer {
    public static final String VALUE_PROPERTY = "Value";
    public static final String MODE_PROPERTY = "Mode";
    public static final String ALL_WORDS_DICTIONARY_PROPERTY = "Dictionaries for casing complete value";
    public static final String WORD_DICTIONARY_PROPERTY = "Dictionaries for casing individual words";
    public static final String BEGIN_WORD_DICTIONARY_PROPERTY = "Dictionaries for casing beginning of words";
    public static final String END_WORD_DICTIONARY_PROPERTY = "Dictionaries for casing ending of words";
    @Configured(value="Value")
    InputColumn<String> valueColumn;
    @Configured(value="Mode")
    TransformationMode mode = TransformationMode.UPPER_CASE;
    @Configured(value="Dictionaries for casing complete value", required=false, order=11)
    Dictionary[] allWordsDictionaries = new Dictionary[0];
    @Configured(value="Dictionaries for casing individual words", required=false, order=12)
    Dictionary[] wordDictionaries = new Dictionary[0];
    @Configured(value="Dictionaries for casing beginning of words", required=false, order=13)
    Dictionary[] wordStartDictionaries = new Dictionary[0];
    @Configured(value="Dictionaries for casing ending of words", required=false, order=14)
    Dictionary[] wordEndDictionaries = new Dictionary[0];
    @Provided
    DataCleanerConfiguration _configuration;
    private DictionaryConnection[] allWordsDictionaryConnections = new DictionaryConnection[0];
    private DictionaryConnection[] wordDictionaryConnections = new DictionaryConnection[0];
    private DictionaryConnection[] wordStartDictionaryConnections = new DictionaryConnection[0];
    private DictionaryConnection[] wordEndDictionaryConnections = new DictionaryConnection[0];

    private DictionaryConnection[] openConnections(Dictionary[] dictionaries) {
        return (DictionaryConnection[])Stream.of(dictionaries).map(d -> d.openConnection(this._configuration)).toArray(DictionaryConnection[]::new);
    }

    @Initialize
    public void init() {
        this.allWordsDictionaryConnections = this.openConnections(this.allWordsDictionaries);
        this.wordDictionaryConnections = this.openConnections(this.wordDictionaries);
        this.wordStartDictionaryConnections = this.openConnections(this.wordStartDictionaries);
        this.wordEndDictionaryConnections = this.openConnections(this.wordEndDictionaries);
    }

    @Validate
    public void validate() {
        this.validateDictionaries(this.allWordsDictionaries);
        this.validateDictionaries(this.wordDictionaries);
        this.validateDictionaries(this.wordStartDictionaries);
        this.validateDictionaries(this.wordEndDictionaries);
    }

    private void validateDictionaries(Dictionary[] dictionaries) {
        if (!Stream.of(dictionaries).allMatch(Dictionary::isCaseSensitive)) {
            throw new IllegalStateException("Dictionaries must be case sensitive");
        }
    }

    public OutputColumns getOutputColumns() {
        return new OutputColumns(String.class, this.valueColumn.getName() + " (" + this.mode.getName() + ")", new String[0]);
    }

    public String[] transform(InputRow row) {
        String value = (String)row.getValue(this.valueColumn);
        String[] result = new String[]{this.transform(value)};
        return result;
    }

    public String transform(String value) {
        if (value == null) {
            return null;
        }
        switch (this.mode) {
            case UPPER_CASE: {
                return UCharacter.toUpperCase((String)value);
            }
            case LOWER_CASE: {
                return UCharacter.toLowerCase((String)value);
            }
            case CAPITALIZE_SENTENCES: {
                return UCharacter.toTitleCase((String)value, (BreakIterator)BreakIterator.getSentenceInstance());
            }
            case CAPITALIZE_WORDS: {
                return this.capitalizeWordsByDictionaries(value);
            }
        }
        throw new UnsupportedOperationException("Unsupported mode: " + (Object)((Object)this.mode));
    }

    private String capitalizeWordsByDictionaries(String value) {
        String preparedString = UCharacter.toTitleCase((String)value, (BreakIterator)BreakIterator.getWordInstance());
        for (DictionaryConnection allWordsDictionaryConnection : this.allWordsDictionaryConnections) {
            Iterator lengthSortedValues = allWordsDictionaryConnection.getLengthSortedValues();
            while (lengthSortedValues.hasNext()) {
                String candidate = (String)lengthSortedValues.next();
                if (!candidate.equalsIgnoreCase(value)) continue;
                return candidate;
            }
        }
        return this.getAllWords(preparedString).stream().map(this::capitalizeWordByDictionaries).collect(Collectors.joining());
    }

    private String capitalizeWordByDictionaries(String input) {
        Stream wordStream = Arrays.stream(this.wordDictionaryConnections).flatMap(DictionaryConnection::stream);
        return wordStream.filter(input::equalsIgnoreCase).findFirst().orElseGet(() -> {
            String startReplaced = this.replaceBeginning(input).orElse(input);
            return this.replaceEnd(startReplaced).orElse(startReplaced);
        });
    }

    private Optional<String> replaceBeginning(String input) {
        Stream wordStartStream = Arrays.stream(this.wordStartDictionaryConnections).flatMap(DictionaryConnection::stream);
        return wordStartStream.filter(c -> input.length() > c.length()).filter(c -> input.toLowerCase().startsWith(c.toLowerCase())).map(c -> c.concat(input.substring(c.length()))).findFirst();
    }

    private Optional<String> replaceEnd(String input) {
        Stream wordEndStream = Arrays.stream(this.wordEndDictionaryConnections).flatMap(DictionaryConnection::stream);
        return wordEndStream.filter(c -> input.length() > c.length()).filter(c -> input.toLowerCase().endsWith(c.toLowerCase())).map(c -> input.substring(0, input.length() - c.length()).concat((String)c)).findFirst();
    }

    private List<String> getAllWords(String preparedString) {
        ArrayList<String> words = new ArrayList<String>();
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(preparedString);
        int start = breakIterator.first();
        int end = breakIterator.next();
        while (end != -1) {
            words.add(preparedString.substring(start, end));
            start = end;
            end = breakIterator.next();
        }
        return words;
    }

    public static enum TransformationMode implements HasName
    {
        LOWER_CASE("Lower case"),
        UPPER_CASE("Upper case"),
        CAPITALIZE_SENTENCES("Capitalize sentences"),
        CAPITALIZE_WORDS("Capitalize every word");

        private final String _name;

        private TransformationMode(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }
    }
}

