/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.transform;

import java.util.Date;
import javax.inject.Named;
import org.apache.metamodel.util.HasName;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.DateAndTimeCategory;
import org.datacleaner.components.convert.ConvertToNumberTransformer;

@Named(value="Timestamp converter")
@Description(value="Convert a timestamp (string or number) to a date field. Epoch is assumed to be 1970-01-01.")
@Categorized(value={DateAndTimeCategory.class})
public class TimestampConverter
implements Transformer {
    @Configured
    InputColumn<?> timestampColumn;
    @Configured
    @Description(value="The unit of measure for comparing the timestamp to the epoch")
    Unit unit = Unit.SECONDS;

    public OutputColumns getOutputColumns() {
        return new OutputColumns(Date.class, this.timestampColumn.getName() + " (as date)", new String[0]);
    }

    public Date[] transform(InputRow inputRow) {
        Date[] result = new Date[1];
        Object value = inputRow.getValue(this.timestampColumn);
        Number number = ConvertToNumberTransformer.transformValue((Object)value);
        if (number != null) {
            Date timestampedDate;
            result[0] = timestampedDate = new Date(number.longValue() * (long)this.unit.getMillisPerUnit());
        }
        return result;
    }

    public static enum Unit implements HasName
    {
        DAYS("Days", 86400000),
        HOURS("Hours", 3600000),
        MINUTES("Minutes", 60000),
        SECONDS("Seconds", 1000),
        MILLIS("Milliseconds", 1);

        private final String _name;
        private final int _millisPerUnit;

        private Unit(String name, int millisPerUnit) {
            this._name = name;
            this._millisPerUnit = millisPerUnit;
        }

        public String getName() {
            return this._name;
        }

        public int getMillisPerUnit() {
            return this._millisPerUnit;
        }
    }
}

