/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.transform;

import javax.inject.Named;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.TextCategory;
import org.datacleaner.util.StringUtils;

@Named(value="Whitespace trimmer")
@Description(value="Trims your String values either on left, right or both sides.")
@Categorized(value={TextCategory.class})
public class WhitespaceTrimmerTransformer
implements Transformer {
    @Configured
    InputColumn<String>[] columns;
    @Configured(order=1)
    boolean trimLeft = true;
    @Configured(order=2)
    boolean trimRight = true;
    @Configured(order=3)
    boolean trimMultipleToSingleSpace = false;

    public WhitespaceTrimmerTransformer() {
    }

    public WhitespaceTrimmerTransformer(boolean trimLeft, boolean trimRight, boolean trimMultipleToSingleSpace) {
        this();
        this.trimLeft = trimLeft;
        this.trimRight = trimRight;
        this.trimMultipleToSingleSpace = trimMultipleToSingleSpace;
    }

    public OutputColumns getOutputColumns() {
        String[] names = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            String name;
            InputColumn<String> column = this.columns[i];
            names[i] = name = column.getName() + " (trimmed)";
        }
        return new OutputColumns(String.class, names);
    }

    public String[] transform(InputRow inputRow) {
        String[] result = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            InputColumn<String> column = this.columns[i];
            String value = (String)inputRow.getValue(column);
            result[i] = value = this.transform(value);
        }
        return result;
    }

    public String transform(String value) {
        if (value == null) {
            return null;
        }
        if (this.trimLeft && this.trimRight) {
            value = value.trim();
        } else {
            if (this.trimLeft) {
                value = StringUtils.leftTrim((String)value);
            }
            if (this.trimRight) {
                value = StringUtils.rightTrim((String)value);
            }
        }
        if (this.trimMultipleToSingleSpace) {
            value = StringUtils.replaceWhitespaces((String)value, (String)" ");
        }
        return value;
    }
}

