/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.eobjects.analyzer.util.ClassLoaderUtils;
import org.eobjects.datacleaner.bootstrap.Bootstrap;
import org.eobjects.datacleaner.bootstrap.DefaultBootstrapOptions;
import org.eobjects.datacleaner.user.DataCleanerHome;
import org.eobjects.metamodel.util.FileHelper;

public final class Main {
    public static final String VERSION = Main.determineVersion();

    public static void main(String[] args) {
        Main.initializeSystemProperties(args);
        Main.initializeLogging();
        DefaultBootstrapOptions bootstrapOptions = new DefaultBootstrapOptions(args);
        Bootstrap bootstrap = new Bootstrap(bootstrapOptions);
        bootstrap.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String determineVersion() {
        Properties properties = new Properties();
        InputStream inputStream = Main.class.getResourceAsStream("/META-INF/maven/org.eobjects.datacleaner/DataCleaner-core/pom.properties");
        try {
            properties.load(inputStream);
        }
        catch (Exception e) {
            String string;
            try {
                Main.println("Failed to load DataCleaner version from manifest: " + e.getMessage());
                string = "UNKNOWN";
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{inputStream});
                throw throwable;
            }
            FileHelper.safeClose((Object[])new Object[]{inputStream});
            return string;
        }
        FileHelper.safeClose((Object[])new Object[]{inputStream});
        String version = properties.getProperty("version");
        Main.println("DataCleaner version: " + version);
        return version;
    }

    protected static Map<String, String> initializeSystemProperties(String[] args) {
        HashMap<String, String> result = new HashMap<String, String>();
        Pattern pattern = Pattern.compile("-D(.+)=(.+)");
        for (String arg : args) {
            Matcher matcher = pattern.matcher(arg);
            if (!matcher.matches()) continue;
            String key = matcher.group(1);
            String value = matcher.group(2);
            result.put(key, value);
            System.setProperty(key, value);
        }
        return result;
    }

    protected static boolean initializeLogging() {
        if (ClassLoaderUtils.IS_WEB_START) {
            URL url = Main.class.getResource("log4j-jnlp.xml");
            assert (url != null);
            Main.println("Using JNLP log configuration: " + url);
            DOMConfigurator.configure((URL)url);
            return true;
        }
        FileObject dataCleanerHome = DataCleanerHome.get();
        try {
            FileObject xmlConfigurationFile = dataCleanerHome.resolveFile("log4j.xml");
            if (xmlConfigurationFile.exists() && xmlConfigurationFile.getType() == FileType.FILE) {
                Main.println("Using custom log configuration: " + xmlConfigurationFile);
                DOMConfigurator.configure((URL)xmlConfigurationFile.getURL());
                return true;
            }
        }
        catch (FileSystemException e) {
            // empty catch block
        }
        try {
            FileObject propertiesConfigurationFile = dataCleanerHome.resolveFile("log4j.properties");
            if (propertiesConfigurationFile.exists() && propertiesConfigurationFile.getType() == FileType.FILE) {
                Main.println("Using custom log configuration: " + propertiesConfigurationFile);
                PropertyConfigurator.configure((URL)propertiesConfigurationFile.getURL());
                return true;
            }
        }
        catch (FileSystemException e) {
            // empty catch block
        }
        URL url = Main.class.getResource("log4j-default.xml");
        assert (url != null);
        Main.println("Using default log configuration: " + url);
        DOMConfigurator.configure((URL)url);
        return false;
    }

    private static void println(String string) {
        System.out.println(string);
    }
}

