/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.AnalyzerJobBuilder;
import org.eobjects.analyzer.job.builder.ExplorerJobBuilder;
import org.eobjects.analyzer.job.builder.FilterJobBuilder;
import org.eobjects.analyzer.job.builder.TransformerJobBuilder;
import org.eobjects.datacleaner.actions.RenameComponentActionListener;
import org.eobjects.datacleaner.util.WidgetFactory;

public abstract class AbstractJobBuilderPopupListener {
    private final AnalysisJobBuilder _analysisJobBuilder;
    private final AbstractBeanJobBuilder<?, ?, ?> _jobBuilder;

    public AbstractJobBuilderPopupListener(AbstractBeanJobBuilder<?, ?, ?> jobBuilder, AnalysisJobBuilder analysisJobBuilder) {
        this._jobBuilder = jobBuilder;
        this._analysisJobBuilder = analysisJobBuilder;
    }

    public AbstractBeanJobBuilder<?, ?, ?> getJobBuilder() {
        return this._jobBuilder;
    }

    public AnalysisJobBuilder getAnalysisJobBuilder() {
        return this._analysisJobBuilder;
    }

    public void showPopup(Component parentComponent, int x, int y) {
        JMenuItem renameMenuItem = WidgetFactory.createMenuItem("Rename component", "images/actions/rename.png");
        renameMenuItem.addActionListener(new RenameComponentActionListener(this._jobBuilder){

            @Override
            protected void onNameChanged() {
                AbstractJobBuilderPopupListener.this.onNameChanged();
            }
        });
        JMenuItem removeMenuItem = WidgetFactory.createMenuItem("Remove component", "images/actions/remove.png");
        removeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractJobBuilderPopupListener.this._jobBuilder instanceof AnalyzerJobBuilder) {
                    AbstractJobBuilderPopupListener.this._analysisJobBuilder.removeAnalyzer((AnalyzerJobBuilder)AbstractJobBuilderPopupListener.this._jobBuilder);
                } else if (AbstractJobBuilderPopupListener.this._jobBuilder instanceof TransformerJobBuilder) {
                    AbstractJobBuilderPopupListener.this._analysisJobBuilder.removeTransformer((TransformerJobBuilder)AbstractJobBuilderPopupListener.this._jobBuilder);
                } else if (AbstractJobBuilderPopupListener.this._jobBuilder instanceof FilterJobBuilder) {
                    AbstractJobBuilderPopupListener.this._analysisJobBuilder.removeFilter((FilterJobBuilder)AbstractJobBuilderPopupListener.this._jobBuilder);
                } else if (AbstractJobBuilderPopupListener.this._jobBuilder instanceof ExplorerJobBuilder) {
                    AbstractJobBuilderPopupListener.this._analysisJobBuilder.removeExplorer((ExplorerJobBuilder)AbstractJobBuilderPopupListener.this._jobBuilder);
                } else {
                    throw new IllegalStateException("Unexpected component type: " + AbstractJobBuilderPopupListener.this._jobBuilder);
                }
                AbstractJobBuilderPopupListener.this.onRemoved();
            }
        });
        JPopupMenu popup = new JPopupMenu();
        popup.add(renameMenuItem);
        popup.add(removeMenuItem);
        popup.show(parentComponent, x, y);
    }

    protected abstract void onNameChanged();

    protected abstract void onRemoved();
}

