/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import org.eobjects.analyzer.data.ConstantInputColumn;
import org.eobjects.analyzer.data.ELInputColumn;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.widgets.properties.PropertyWidget;
import org.eobjects.metamodel.util.CollectionUtils;

public class AddExpressionBasedColumnActionListener
implements ActionListener {
    private final PropertyWidget<InputColumn<?>> _singlePropertyWidget;
    private final PropertyWidget<InputColumn<?>[]> _multiplePropertyWidget;

    public static AddExpressionBasedColumnActionListener forSingleColumn(PropertyWidget<InputColumn<?>> singlePropertyWidget) {
        return new AddExpressionBasedColumnActionListener(singlePropertyWidget, null);
    }

    public static AddExpressionBasedColumnActionListener forMultipleColumns(PropertyWidget<InputColumn<?>[]> multiplePropertyWidget) {
        return new AddExpressionBasedColumnActionListener(null, multiplePropertyWidget);
    }

    private AddExpressionBasedColumnActionListener(PropertyWidget<InputColumn<?>> singlePropertyWidget, PropertyWidget<InputColumn<?>[]> multiplePropertyWidget) {
        this._singlePropertyWidget = singlePropertyWidget;
        this._multiplePropertyWidget = multiplePropertyWidget;
    }

    public PropertyWidget<?> getPropertyWidget() {
        return this._singlePropertyWidget == null ? this._multiplePropertyWidget : this._singlePropertyWidget;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String expression = JOptionPane.showInputDialog(this.getPropertyWidget().getWidget(), "In stead of referencing a column you can also enter an expression.\nAn expression may either be a constant string or an EL-expression\nthat can access the other columns using the #{column_name} syntax.", "");
        this.addExpressionBasedInputColumn(expression);
    }

    public void addExpressionBasedInputColumn(String expression) {
        if (!StringUtils.isNullOrEmpty((String)expression)) {
            Object expressionBasedInputColumn = expression.indexOf("#{") != -1 ? new ELInputColumn(expression) : new ConstantInputColumn(expression);
            if (this._multiplePropertyWidget != null) {
                Object[] currentValue = this._multiplePropertyWidget.getValue();
                if (currentValue == null) {
                    currentValue = new InputColumn[]{};
                }
                InputColumn[] newValue = (InputColumn[])CollectionUtils.array((Object[])currentValue, (Object[])new InputColumn[]{expressionBasedInputColumn});
                this._multiplePropertyWidget.onValueTouched(newValue);
            } else {
                this._singlePropertyWidget.onValueTouched((InputColumn<?>)expressionBasedInputColumn);
            }
        }
    }
}

