/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.inject.Inject;
import javax.swing.JMenuItem;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.descriptors.AnalyzerBeanDescriptor;
import org.eobjects.analyzer.descriptors.BeanDescriptor;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.datacleaner.user.UsageLogger;
import org.eobjects.datacleaner.widgets.DescriptorMenuItem;
import org.eobjects.datacleaner.widgets.DescriptorPopupMenu;

public final class AnalyzeButtonActionListener
implements ActionListener {
    private final AnalyzerBeansConfiguration _configuration;
    private final AnalysisJobBuilder _analysisJobBuilder;
    private final UsageLogger _usageLogger;

    @Inject
    protected AnalyzeButtonActionListener(AnalyzerBeansConfiguration configuration, AnalysisJobBuilder analysisJobBuilder, UsageLogger usageLogger) {
        this._configuration = configuration;
        this._analysisJobBuilder = analysisJobBuilder;
        this._usageLogger = usageLogger;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection descriptors = this._configuration.getDescriptorProvider().getAnalyzerBeanDescriptors();
        DescriptorPopupMenu popup = new DescriptorPopupMenu<AnalyzerBeanDescriptor<?>>(descriptors){
            private static final long serialVersionUID = 1L;

            @Override
            protected JMenuItem createMenuItem(final AnalyzerBeanDescriptor<?> descriptor) {
                DescriptorMenuItem menuItem = new DescriptorMenuItem((BeanDescriptor<?>)descriptor);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Class analyzerClass = descriptor.getComponentClass();
                        AnalyzeButtonActionListener.this._analysisJobBuilder.addAnalyzer(analyzerClass);
                        AnalyzeButtonActionListener.this._usageLogger.log("Add analyzer: " + descriptor.getDisplayName());
                    }
                });
                return menuItem;
            }
        };
        Component source = (Component)e.getSource();
        popup.show(source, 0, source.getHeight());
    }
}

