/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.ComponentCategory;
import org.eobjects.analyzer.beans.writers.WriteDataCategory;
import org.eobjects.analyzer.descriptors.FilterBeanDescriptor;
import org.eobjects.analyzer.job.FilterOutcome;
import org.eobjects.analyzer.job.Outcome;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.AnalyzerJobBuilder;
import org.eobjects.analyzer.job.builder.FilterJobBuilder;
import org.eobjects.datacleaner.actions.DisplayOutputWritersAction;
import org.eobjects.datacleaner.output.beans.AbstractOutputWriterAnalyzer;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.widgets.DescriptorMenu;

public class DisplayOptionsForFilterOutcomeActionListener
extends DisplayOutputWritersAction
implements ActionListener {
    private static final ImageManager imageManager = ImageManager.getInstance();
    private final FilterJobBuilder<?, ?> _filterJobBuilder;
    private final String _categoryName;

    public DisplayOptionsForFilterOutcomeActionListener(FilterJobBuilder<?, ?> filterJobBuilder, String categoryName) {
        super(filterJobBuilder.getAnalysisJobBuilder());
        this._filterJobBuilder = filterJobBuilder;
        this._categoryName = categoryName;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FilterOutcome requirement = this._filterJobBuilder.getOutcome((Object)((FilterBeanDescriptor)this._filterJobBuilder.getDescriptor()).getOutcomeCategoryByName(this._categoryName));
        DescriptorMenu writeDataMenu = new DescriptorMenu((ComponentCategory)new WriteDataCategory());
        List<JMenuItem> writerDataMenuItems = this.createMenuItems();
        for (JMenuItem menuItem : writerDataMenuItems) {
            writeDataMenu.add(menuItem);
        }
        final AnalysisJobBuilder analysisJobBuilder = this._filterJobBuilder.getAnalysisJobBuilder();
        JMenuItem setAsDefaultOutcomeMenuItem = new JMenuItem("Set as default requirement");
        setAsDefaultOutcomeMenuItem.setToolTipText("Makes this filter outcome the default choice for other components in the job.");
        Outcome existingDefaultRequirement = analysisJobBuilder.getDefaultRequirement();
        if (requirement.equals(existingDefaultRequirement)) {
            setAsDefaultOutcomeMenuItem.setIcon(imageManager.getImageIcon("images/status/valid.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
        }
        setAsDefaultOutcomeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Enum category = ((FilterBeanDescriptor)DisplayOptionsForFilterOutcomeActionListener.this._filterJobBuilder.getDescriptor()).getOutcomeCategoryByName(DisplayOptionsForFilterOutcomeActionListener.this._categoryName);
                FilterOutcome outcome = DisplayOptionsForFilterOutcomeActionListener.this._filterJobBuilder.getOutcome((Object)category);
                analysisJobBuilder.setDefaultRequirement((Outcome)outcome);
            }
        });
        JPopupMenu popup = new JPopupMenu();
        popup.add(writeDataMenu);
        popup.add(setAsDefaultOutcomeMenuItem);
        JComponent component = (JComponent)e.getSource();
        popup.show(component, 0, component.getHeight());
    }

    @Override
    protected void configure(AnalysisJobBuilder analysisJobBuilder, AnalyzerJobBuilder<?> analyzerJobBuilder) {
        Analyzer analyzer = (Analyzer)analyzerJobBuilder.getConfigurableBean();
        if (analyzer instanceof AbstractOutputWriterAnalyzer) {
            ((AbstractOutputWriterAnalyzer)analyzer).configureForFilterOutcome(analysisJobBuilder, (FilterBeanDescriptor)this._filterJobBuilder.getDescriptor(), this._categoryName);
        }
        analyzerJobBuilder.setRequirement(this._filterJobBuilder, this._categoryName);
    }
}

