/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.eobjects.analyzer.beans.writers.WriteDataCategory;
import org.eobjects.analyzer.descriptors.AnalyzerBeanDescriptor;
import org.eobjects.analyzer.descriptors.BeanDescriptor;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.AnalyzerJobBuilder;
import org.eobjects.analyzer.util.CollectionUtils2;
import org.eobjects.datacleaner.util.DisplayNameComparator;
import org.eobjects.datacleaner.widgets.DescriptorMenuItem;

public class DisplayOutputWritersAction {
    private final AnalysisJobBuilder _analysisJobBuilder;

    public DisplayOutputWritersAction(AnalysisJobBuilder analysisJobBuilder) {
        this._analysisJobBuilder = analysisJobBuilder;
    }

    public final void showPopup(JComponent component) {
        JPopupMenu popup = new JPopupMenu();
        List<JMenuItem> menuItems = this.createMenuItems();
        for (JMenuItem menuItem : menuItems) {
            popup.add(menuItem);
        }
        popup.show(component, 0, component.getHeight());
    }

    public List<JMenuItem> createMenuItems() {
        ArrayList<JMenuItem> result = new ArrayList<JMenuItem>();
        for (final AnalyzerBeanDescriptor<?> descriptor : this.getDescriptors()) {
            DescriptorMenuItem outputWriterMenuItem = new DescriptorMenuItem((BeanDescriptor<?>)descriptor);
            outputWriterMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Class beanClass = descriptor.getComponentClass();
                    AnalyzerJobBuilder ajb = DisplayOutputWritersAction.this._analysisJobBuilder.addAnalyzer(beanClass);
                    DisplayOutputWritersAction.this.configure(DisplayOutputWritersAction.this._analysisJobBuilder, ajb);
                    ajb.onConfigurationChanged();
                }
            });
            result.add(outputWriterMenuItem);
        }
        return result;
    }

    protected void configure(AnalysisJobBuilder analysisJobBuilder, AnalyzerJobBuilder<?> analyzerJobBuilder) {
    }

    protected List<AnalyzerBeanDescriptor<?>> getDescriptors() {
        Collection descriptors = this._analysisJobBuilder.getConfiguration().getDescriptorProvider().getAnalyzerBeanDescriptors();
        List result = CollectionUtils2.sorted((Collection)descriptors, (Comparator)new DisplayNameComparator());
        Iterator it = result.iterator();
        while (it.hasNext()) {
            AnalyzerBeanDescriptor descriptor = (AnalyzerBeanDescriptor)it.next();
            Set categories = descriptor.getComponentCategories();
            if (categories.contains(new WriteDataCategory())) continue;
            it.remove();
        }
        return result;
    }
}

