/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.swing.SwingWorker;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.eobjects.analyzer.job.tasks.Task;
import org.eobjects.analyzer.util.VFSUtils;
import org.eobjects.datacleaner.actions.FileDownloadListener;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.InvalidHttpResponseException;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.windows.FileTransferProgressWindow;
import org.eobjects.metamodel.util.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadFilesActionListener
extends SwingWorker<FileObject[], Task>
implements ActionListener {
    private static final Logger logger = LoggerFactory.getLogger(DownloadFilesActionListener.class);
    private final String[] _urls;
    private final FileObject[] _files;
    private final FileDownloadListener _listener;
    private final FileTransferProgressWindow _downloadProgressWindow;
    private final HttpClient _httpClient;
    private volatile boolean _cancelled = false;

    public DownloadFilesActionListener(String[] urls, FileDownloadListener listener, WindowContext windowContext, HttpClient httpClient, UserPreferences userPreferences) {
        this(urls, DownloadFilesActionListener.createTargetDirectory(userPreferences), DownloadFilesActionListener.createTargetFilenames(urls), listener, windowContext, httpClient);
    }

    public DownloadFilesActionListener(String[] urls, String[] targetFilenames, FileDownloadListener listener, WindowContext windowContext, HttpClient httpClient, UserPreferences userPreferences) {
        this(urls, DownloadFilesActionListener.createTargetDirectory(userPreferences), targetFilenames, listener, windowContext, httpClient);
    }

    public DownloadFilesActionListener(String[] urls, FileObject targetDirectory, String[] targetFilenames, FileDownloadListener listener, WindowContext windowContext, HttpClient httpClient) {
        if (urls == null) {
            throw new IllegalArgumentException("urls cannot be null");
        }
        this._urls = urls;
        this._listener = listener;
        this._files = new FileObject[this._urls.length];
        String[] finalFilenames = new String[this._files.length];
        for (int i = 0; i < urls.length; ++i) {
            String filename = targetFilenames[i];
            try {
                this._files[i] = targetDirectory.resolveFile(filename);
                finalFilenames[i] = this._files[i].getName().getBaseName();
                continue;
            }
            catch (FileSystemException e) {
                throw new IllegalStateException(e);
            }
        }
        Action<Void> cancelCallback = new Action<Void>(){

            public void run(Void arg0) throws Exception {
                DownloadFilesActionListener.this.cancelDownload();
            }
        };
        this._downloadProgressWindow = new FileTransferProgressWindow(windowContext, cancelCallback, finalFilenames);
        this._httpClient = httpClient;
    }

    private static FileObject createTargetDirectory(UserPreferences userPreferences) {
        File localDirectory = userPreferences.getSaveDownloadedFilesDirectory();
        try {
            return VFSUtils.getFileSystemManager().toFileObject(localDirectory);
        }
        catch (FileSystemException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String[] createTargetFilenames(String[] urls) {
        String[] filenames = new String[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            String filename;
            String url = urls[i];
            if (url == null) {
                throw new IllegalArgumentException("urls[" + i + "] cannot be null");
            }
            filenames[i] = filename = url.substring(url.lastIndexOf(47) + 1);
        }
        return filenames;
    }

    public FileObject[] getFiles() {
        try {
            this.get();
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException(e);
        }
        return this._files;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this._downloadProgressWindow.setVisible(true);
        this.execute();
    }

    @Override
    protected void process(List<Task> chunks) {
        for (Task task : chunks) {
            try {
                task.execute();
            }
            catch (Exception e) {
                WidgetUtils.showErrorMessage("Error processing transfer chunk: " + task, e);
            }
        }
    }

    public void cancelDownload() {
        logger.info("Cancel of download requested");
        this._cancelled = true;
    }

    @Override
    protected void done() {
        super.done();
        if (!this._cancelled) {
            try {
                FileObject[] files = (FileObject[])this.get();
                if (this._listener != null) {
                    this._listener.onFilesDownloaded(files);
                }
            }
            catch (Throwable e) {
                WidgetUtils.showErrorMessage("Error transfering file(s)!", e);
            }
        }
    }

    @Override
    protected FileObject[] doInBackground() throws Exception {
        for (int i = 0; i < this._urls.length; ++i) {
            String url = this._urls[i];
            final FileObject file = this._files[i];
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                byte[] buffer = new byte[1024];
                HttpGet method = new HttpGet(url);
                if (!this._cancelled) {
                    HttpResponse response = this._httpClient.execute((HttpUriRequest)method);
                    if (response.getStatusLine().getStatusCode() != 200) {
                        throw new InvalidHttpResponseException(url, response);
                    }
                    HttpEntity responseEntity = response.getEntity();
                    final long expectedSize = responseEntity.getContentLength();
                    if (expectedSize > 0L) {
                        this.publish(new Task(){

                            public void execute() throws Exception {
                                DownloadFilesActionListener.this._downloadProgressWindow.setExpectedSize(file.getName().getBaseName(), expectedSize);
                            }
                        });
                    }
                    inputStream = responseEntity.getContent();
                    if (!file.exists()) {
                        file.createFile();
                    }
                    outputStream = file.getContent().getOutputStream();
                    long bytes = 0L;
                    int numBytes = inputStream.read(buffer);
                    while (numBytes != -1 && !this._cancelled) {
                        outputStream.write(buffer, 0, numBytes);
                        final long totalBytes = bytes += (long)numBytes;
                        this.publish(new Task(){

                            public void execute() throws Exception {
                                DownloadFilesActionListener.this._downloadProgressWindow.setProgress(file.getName().getBaseName(), totalBytes);
                            }
                        });
                        numBytes = inputStream.read(buffer);
                    }
                    if (!this._cancelled) {
                        this.publish(new Task(){

                            public void execute() throws Exception {
                                DownloadFilesActionListener.this._downloadProgressWindow.setFinished(file.getName().getBaseName());
                            }
                        });
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        logger.warn("Could not close input stream: " + e.getMessage(), (Throwable)e);
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException e) {
                        logger.warn("Could not flush & close output stream: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (!this._cancelled) continue;
            logger.info("Deleting non-finished download-file '{}'", (Object)file);
            file.delete();
        }
        return this._files;
    }
}

