/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.result.AnalysisResult;
import org.eobjects.analyzer.result.html.HtmlAnalysisResultWriter;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.FileFilters;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCFileChooser;
import org.eobjects.metamodel.util.FileHelper;
import org.eobjects.metamodel.util.Ref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportResultToHtmlActionListener
implements ActionListener {
    private static final Logger logger = LoggerFactory.getLogger(ExportResultToHtmlActionListener.class);
    private final Ref<AnalysisResult> _result;
    private final UserPreferences _userPreferences;
    private final AnalyzerBeansConfiguration _configuration;

    public ExportResultToHtmlActionListener(Ref<AnalysisResult> result, AnalyzerBeansConfiguration configuration, UserPreferences userPreferences) {
        this._result = result;
        this._configuration = configuration;
        this._userPreferences = userPreferences;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        final AnalysisResult analysisResult = (AnalysisResult)this._result.get();
        if (analysisResult == null) {
            WidgetUtils.showErrorMessage("Result not ready", "Please wait for the job to finish before saving the result", null);
            return;
        }
        DCFileChooser fileChooser = new DCFileChooser(this._userPreferences.getAnalysisJobDirectory());
        fileChooser.setFileFilter(FileFilters.HTML);
        Component parent = event.getSource() instanceof Component ? (Component)event.getSource() : null;
        int result = fileChooser.showSaveDialog(parent);
        if (result == 0) {
            int overwrite;
            File file = fileChooser.getSelectedFile();
            if (!file.getName().endsWith(FileFilters.HTML.getExtension())) {
                file = new File(file.getParentFile(), file.getName() + FileFilters.HTML.getExtension());
            }
            if (file.exists() && (overwrite = JOptionPane.showConfirmDialog(parent, "Are you sure you want to overwrite the file '" + file.getName() + "'?", "Overwrite existing file?", 0)) != 0) {
                return;
            }
            final BufferedWriter writer = FileHelper.getBufferedWriter((File)file);
            new SwingWorker<Void, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected Void doInBackground() throws Exception {
                    HtmlAnalysisResultWriter resultWriter = new HtmlAnalysisResultWriter();
                    try {
                        logger.debug("Begin write to HTML");
                        resultWriter.write(analysisResult, ExportResultToHtmlActionListener.this._configuration, writer);
                        logger.debug("End write to HTML");
                    }
                    catch (Throwable throwable) {
                        FileHelper.safeClose((Object[])new Object[]{writer});
                        throw throwable;
                    }
                    FileHelper.safeClose((Object[])new Object[]{writer});
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                    }
                    catch (ExecutionException e) {
                        logger.error("ExecutionException occurred while getting the result of the HTML rendering", (Throwable)e);
                        Throwable cause = e.getCause();
                        WidgetUtils.showErrorMessage("Error writing result to HTML page", cause);
                    }
                    catch (InterruptedException e) {
                        logger.warn("Unexpected interrupt in done() method!");
                    }
                }
            }.execute();
        }
    }
}

