/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.actions;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Timer;

public abstract class MoveComponentTimerActionListener
implements ActionListener {
    private final JComponent component;
    private final int x;
    private final int y;
    private volatile int numSteps;

    public MoveComponentTimerActionListener(JComponent component, int x, int y, int numSteps) {
        if (numSteps <= 0) {
            throw new IllegalArgumentException("numSteps must be a postive number");
        }
        this.component = component;
        this.x = x;
        this.y = y;
        this.numSteps = numSteps;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Timer timer = (Timer)e.getSource();
        Point location = this.component.getLocation();
        int currentX = location.x;
        int currentY = location.y;
        if (currentX == this.x && currentY == this.y) {
            timer.stop();
        } else if (this.numSteps <= 1) {
            this.component.setLocation(this.x, this.y);
            this.done();
        } else {
            int diffX = this.x - currentX;
            int diffY = this.y - currentY;
            this.component.setLocation(currentX + (diffX /= this.numSteps), currentY + (diffY /= this.numSteps));
        }
        --this.numSteps;
    }

    protected abstract void done();
}

